/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.completion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class CompletionRequest {
    @NonNull
    private String model;
    @NonNull
    private String prompt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String suffix;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double temperature;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer n;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean stream;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer logprobs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean echo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> stop;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="best_of")
    private Integer bestOf;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String user;

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public static CompletionRequestBuilder builder() {
        return new CompletionRequestBuilder();
    }

    public CompletionRequest() {
    }

    public CompletionRequest(@NonNull String model, @NonNull String prompt, String suffix, Integer maxTokens, Double temperature, Double topP, Integer n, Boolean stream, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty, Integer bestOf, Map<String, Integer> logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.model = model;
        this.prompt = prompt;
        this.suffix = suffix;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.bestOf = bestOf;
        this.logitBias = logitBias;
        this.user = user;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public Boolean getEcho() {
        return this.echo;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "CompletionRequest(model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", suffix=" + this.getSuffix() + ", maxTokens=" + this.getMaxTokens() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.getStream() + ", logprobs=" + this.getLogprobs() + ", echo=" + this.getEcho() + ", stop=" + this.getStop() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", bestOf=" + this.getBestOf() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public static class CompletionRequestBuilder {
        private String model;
        private String prompt;
        private String suffix;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Integer bestOf;
        private Map<String, Integer> logitBias;
        private String user;

        CompletionRequestBuilder() {
        }

        public CompletionRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public CompletionRequestBuilder prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return this;
        }

        public CompletionRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public CompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public CompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public CompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public CompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public CompletionRequestBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public CompletionRequestBuilder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public CompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public CompletionRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public CompletionRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="best_of")
        public CompletionRequestBuilder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public CompletionRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public CompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this.model, this.prompt, this.suffix, this.maxTokens, this.temperature, this.topP, this.n, this.stream, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.bestOf, this.logitBias, this.user);
        }

        public String toString() {
            return "CompletionRequest.CompletionRequestBuilder(model=" + this.model + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", maxTokens=" + this.maxTokens + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", logprobs=" + this.logprobs + ", echo=" + this.echo + ", stop=" + this.stop + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", bestOf=" + this.bestOf + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }
}

