/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.filter.AudioFilter;
import io.github.sashirestela.openai.filter.StreamFilter;
import io.github.sashirestela.openai.http.HttpProcessor;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Optional;
import lombok.NonNull;

public class SimpleOpenAI {
    private final String OPENAI_URL_BASE = "https://api.openai.com";
    public final String AUTHORIZATION_HEADER = "Authorization";
    private final String ORGANIZATION_HEADER = "OpenAI-Organization";
    public final String BEARER_AUTHORIZATION = "Bearer ";
    @NonNull
    private String apiKey;
    private String organizationId;
    private String urlBase;
    private HttpClient httpClient;
    private HttpProcessor httpProcessor;
    private OpenAI.Audios audioService;
    private OpenAI.ChatCompletions chatCompletionService;
    private OpenAI.Completions completionService;
    private OpenAI.Embeddings embeddingService;
    private OpenAI.Files fileService;
    private OpenAI.FineTunings fineTuningService;
    private OpenAI.Images imageService;
    private OpenAI.Models modelService;
    private OpenAI.Moderations moderationService;

    public SimpleOpenAI(String apiKey, String organizationId, String urlBase, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.organizationId = organizationId;
        this.urlBase = Optional.ofNullable(urlBase).orElse("https://api.openai.com");
        this.httpClient = Optional.ofNullable(httpClient).orElse(HttpClient.newHttpClient());
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Authorization");
        headers.add("Bearer " + apiKey);
        if (organizationId != null) {
            headers.add("OpenAI-Organization");
            headers.add(organizationId);
        }
        this.httpProcessor = HttpProcessor.builder().httpClient(this.httpClient).urlBase(this.urlBase).headers(headers).build();
    }

    public OpenAI.Audios audios() {
        if (this.audioService == null) {
            this.audioService = this.httpProcessor.create(OpenAI.Audios.class, new AudioFilter());
        }
        return this.audioService;
    }

    public OpenAI.ChatCompletions chatCompletions() {
        if (this.chatCompletionService == null) {
            this.chatCompletionService = this.httpProcessor.create(OpenAI.ChatCompletions.class, new StreamFilter());
        }
        return this.chatCompletionService;
    }

    public OpenAI.Completions completions() {
        if (this.completionService == null) {
            this.completionService = this.httpProcessor.create(OpenAI.Completions.class, new StreamFilter());
        }
        return this.completionService;
    }

    public OpenAI.Embeddings embeddings() {
        if (this.embeddingService == null) {
            this.embeddingService = this.httpProcessor.create(OpenAI.Embeddings.class, null);
        }
        return this.embeddingService;
    }

    public OpenAI.Files files() {
        if (this.fileService == null) {
            this.fileService = this.httpProcessor.create(OpenAI.Files.class, null);
        }
        return this.fileService;
    }

    public OpenAI.FineTunings fineTunings() {
        if (this.fineTuningService == null) {
            this.fineTuningService = this.httpProcessor.create(OpenAI.FineTunings.class, null);
        }
        return this.fineTuningService;
    }

    public OpenAI.Images images() {
        if (this.imageService == null) {
            this.imageService = this.httpProcessor.create(OpenAI.Images.class, null);
        }
        return this.imageService;
    }

    public OpenAI.Models models() {
        if (this.modelService == null) {
            this.modelService = this.httpProcessor.create(OpenAI.Models.class, null);
        }
        return this.modelService;
    }

    public OpenAI.Moderations moderations() {
        if (this.moderationService == null) {
            this.moderationService = this.httpProcessor.create(OpenAI.Moderations.class, null);
        }
        return this.moderationService;
    }

    public static SimpleOpenAIBuilder builder() {
        return new SimpleOpenAIBuilder();
    }

    public SimpleOpenAI() {
    }

    public String getOPENAI_URL_BASE() {
        return this.OPENAI_URL_BASE;
    }

    public String getAUTHORIZATION_HEADER() {
        return this.AUTHORIZATION_HEADER;
    }

    public String getORGANIZATION_HEADER() {
        return this.ORGANIZATION_HEADER;
    }

    public String getBEARER_AUTHORIZATION() {
        return this.BEARER_AUTHORIZATION;
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public OpenAI.Audios getAudioService() {
        return this.audioService;
    }

    public OpenAI.ChatCompletions getChatCompletionService() {
        return this.chatCompletionService;
    }

    public OpenAI.Completions getCompletionService() {
        return this.completionService;
    }

    public OpenAI.Embeddings getEmbeddingService() {
        return this.embeddingService;
    }

    public OpenAI.Files getFileService() {
        return this.fileService;
    }

    public OpenAI.FineTunings getFineTuningService() {
        return this.fineTuningService;
    }

    public OpenAI.Images getImageService() {
        return this.imageService;
    }

    public OpenAI.Models getModelService() {
        return this.modelService;
    }

    public OpenAI.Moderations getModerationService() {
        return this.moderationService;
    }

    public static class SimpleOpenAIBuilder {
        private String apiKey;
        private String organizationId;
        private String urlBase;
        private HttpClient httpClient;

        SimpleOpenAIBuilder() {
        }

        public SimpleOpenAIBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public SimpleOpenAIBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public SimpleOpenAIBuilder urlBase(String urlBase) {
            this.urlBase = urlBase;
            return this;
        }

        public SimpleOpenAIBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SimpleOpenAI build() {
            return new SimpleOpenAI(this.apiKey, this.organizationId, this.urlBase, this.httpClient);
        }

        public String toString() {
            return "SimpleOpenAI.SimpleOpenAIBuilder(apiKey=" + this.apiKey + ", organizationId=" + this.organizationId + ", urlBase=" + this.urlBase + ", httpClient=" + this.httpClient + ")";
        }
    }
}

