/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.image;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.sashirestela.openai.domain.image.AbstractImageRequest;
import java.nio.file.Path;
import lombok.NonNull;

public class ImageEditsRequest
extends AbstractImageRequest {
    @NonNull
    private Path image;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Path mask;
    @NonNull
    private String prompt;

    protected ImageEditsRequest(ImageEditsRequestBuilder<?, ?> b) {
        super(b);
        this.image = b.image;
        if (this.image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.mask = b.mask;
        this.prompt = b.prompt;
        if (this.prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
    }

    public static ImageEditsRequestBuilder<?, ?> builder() {
        return new ImageEditsRequestBuilderImpl();
    }

    public ImageEditsRequest() {
    }

    public ImageEditsRequest(@NonNull Path image, Path mask, @NonNull String prompt) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.image = image;
        this.mask = mask;
        this.prompt = prompt;
    }

    @NonNull
    public Path getImage() {
        return this.image;
    }

    public Path getMask() {
        return this.mask;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public String toString() {
        return "ImageEditsRequest(image=" + this.getImage() + ", mask=" + this.getMask() + ", prompt=" + this.getPrompt() + ")";
    }

    private static final class ImageEditsRequestBuilderImpl
    extends ImageEditsRequestBuilder<ImageEditsRequest, ImageEditsRequestBuilderImpl> {
        private ImageEditsRequestBuilderImpl() {
        }

        @Override
        protected ImageEditsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ImageEditsRequest build() {
            return new ImageEditsRequest(this);
        }
    }

    public static abstract class ImageEditsRequestBuilder<C extends ImageEditsRequest, B extends ImageEditsRequestBuilder<C, B>>
    extends AbstractImageRequest.AbstractImageRequestBuilder<C, B> {
        private Path image;
        private Path mask;
        private String prompt;

        public B image(@NonNull Path image) {
            if (image == null) {
                throw new NullPointerException("image is marked non-null but is null");
            }
            this.image = image;
            return (B)this.self();
        }

        public B mask(Path mask) {
            this.mask = mask;
            return (B)this.self();
        }

        public B prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageEditsRequest.ImageEditsRequestBuilder(super=" + super.toString() + ", image=" + this.image + ", mask=" + this.mask + ", prompt=" + this.prompt + ")";
        }
    }
}

