/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetune;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.NonNull;

public class FineTuneRequest {
    @JsonProperty(value="training_file")
    @NonNull
    private String trainingFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="validation_file")
    private String validationFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String model;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="n_epochs")
    private Integer numberEpochs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="batch_size")
    private Integer batchSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="learning_rate_multiplier")
    private Double learningRateMultiplier;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="prompt_loss_weight")
    private Double promptLossWeight;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="compute_classification_metrics")
    private Boolean computeClassificationMetrics;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="classification_n_classes")
    private Integer classificationNClasses;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="classification_positive_class")
    private String classificationPositiveClass;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="classification_betas")
    private List<Double> classificationBetas;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String suffix;

    public static FineTuneRequestBuilder builder() {
        return new FineTuneRequestBuilder();
    }

    public FineTuneRequest() {
    }

    public FineTuneRequest(@NonNull String trainingFile, String validationFile, String model, Integer numberEpochs, Integer batchSize, Double learningRateMultiplier, Double promptLossWeight, Boolean computeClassificationMetrics, Integer classificationNClasses, String classificationPositiveClass, List<Double> classificationBetas, String suffix) {
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.model = model;
        this.numberEpochs = numberEpochs;
        this.batchSize = batchSize;
        this.learningRateMultiplier = learningRateMultiplier;
        this.promptLossWeight = promptLossWeight;
        this.computeClassificationMetrics = computeClassificationMetrics;
        this.classificationNClasses = classificationNClasses;
        this.classificationPositiveClass = classificationPositiveClass;
        this.classificationBetas = classificationBetas;
        this.suffix = suffix;
    }

    @NonNull
    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getNumberEpochs() {
        return this.numberEpochs;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Double getLearningRateMultiplier() {
        return this.learningRateMultiplier;
    }

    public Double getPromptLossWeight() {
        return this.promptLossWeight;
    }

    public Boolean getComputeClassificationMetrics() {
        return this.computeClassificationMetrics;
    }

    public Integer getClassificationNClasses() {
        return this.classificationNClasses;
    }

    public String getClassificationPositiveClass() {
        return this.classificationPositiveClass;
    }

    public List<Double> getClassificationBetas() {
        return this.classificationBetas;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return "FineTuneRequest(trainingFile=" + this.getTrainingFile() + ", validationFile=" + this.getValidationFile() + ", model=" + this.getModel() + ", numberEpochs=" + this.getNumberEpochs() + ", batchSize=" + this.getBatchSize() + ", learningRateMultiplier=" + this.getLearningRateMultiplier() + ", promptLossWeight=" + this.getPromptLossWeight() + ", computeClassificationMetrics=" + this.getComputeClassificationMetrics() + ", classificationNClasses=" + this.getClassificationNClasses() + ", classificationPositiveClass=" + this.getClassificationPositiveClass() + ", classificationBetas=" + this.getClassificationBetas() + ", suffix=" + this.getSuffix() + ")";
    }

    public static class FineTuneRequestBuilder {
        private String trainingFile;
        private String validationFile;
        private String model;
        private Integer numberEpochs;
        private Integer batchSize;
        private Double learningRateMultiplier;
        private Double promptLossWeight;
        private Boolean computeClassificationMetrics;
        private Integer classificationNClasses;
        private String classificationPositiveClass;
        private List<Double> classificationBetas;
        private String suffix;

        FineTuneRequestBuilder() {
        }

        @JsonProperty(value="training_file")
        public FineTuneRequestBuilder trainingFile(@NonNull String trainingFile) {
            if (trainingFile == null) {
                throw new NullPointerException("trainingFile is marked non-null but is null");
            }
            this.trainingFile = trainingFile;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuneRequestBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuneRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @JsonProperty(value="n_epochs")
        public FineTuneRequestBuilder numberEpochs(Integer numberEpochs) {
            this.numberEpochs = numberEpochs;
            return this;
        }

        @JsonProperty(value="batch_size")
        public FineTuneRequestBuilder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @JsonProperty(value="learning_rate_multiplier")
        public FineTuneRequestBuilder learningRateMultiplier(Double learningRateMultiplier) {
            this.learningRateMultiplier = learningRateMultiplier;
            return this;
        }

        @JsonProperty(value="prompt_loss_weight")
        public FineTuneRequestBuilder promptLossWeight(Double promptLossWeight) {
            this.promptLossWeight = promptLossWeight;
            return this;
        }

        @JsonProperty(value="compute_classification_metrics")
        public FineTuneRequestBuilder computeClassificationMetrics(Boolean computeClassificationMetrics) {
            this.computeClassificationMetrics = computeClassificationMetrics;
            return this;
        }

        @JsonProperty(value="classification_n_classes")
        public FineTuneRequestBuilder classificationNClasses(Integer classificationNClasses) {
            this.classificationNClasses = classificationNClasses;
            return this;
        }

        @JsonProperty(value="classification_positive_class")
        public FineTuneRequestBuilder classificationPositiveClass(String classificationPositiveClass) {
            this.classificationPositiveClass = classificationPositiveClass;
            return this;
        }

        @JsonProperty(value="classification_betas")
        public FineTuneRequestBuilder classificationBetas(List<Double> classificationBetas) {
            this.classificationBetas = classificationBetas;
            return this;
        }

        public FineTuneRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTuneRequest build() {
            return new FineTuneRequest(this.trainingFile, this.validationFile, this.model, this.numberEpochs, this.batchSize, this.learningRateMultiplier, this.promptLossWeight, this.computeClassificationMetrics, this.classificationNClasses, this.classificationPositiveClass, this.classificationBetas, this.suffix);
        }

        public String toString() {
            return "FineTuneRequest.FineTuneRequestBuilder(trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", model=" + this.model + ", numberEpochs=" + this.numberEpochs + ", batchSize=" + this.batchSize + ", learningRateMultiplier=" + this.learningRateMultiplier + ", promptLossWeight=" + this.promptLossWeight + ", computeClassificationMetrics=" + this.computeClassificationMetrics + ", classificationNClasses=" + this.classificationNClasses + ", classificationPositiveClass=" + this.classificationPositiveClass + ", classificationBetas=" + this.classificationBetas + ", suffix=" + this.suffix + ")";
        }
    }
}

