/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.openai.domain.audio.AudioResponse;
import io.github.sashirestela.openai.domain.audio.AudioTranscribeRequest;
import io.github.sashirestela.openai.domain.audio.AudioTranslateRequest;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.chat.ChatResponse;
import io.github.sashirestela.openai.domain.completion.CompletionRequest;
import io.github.sashirestela.openai.domain.completion.CompletionResponse;
import io.github.sashirestela.openai.domain.embedding.EmbeddingRequest;
import io.github.sashirestela.openai.domain.embedding.EmbeddingResponse;
import io.github.sashirestela.openai.domain.file.FileDeletedResponse;
import io.github.sashirestela.openai.domain.file.FileRequest;
import io.github.sashirestela.openai.domain.file.FileResponse;
import io.github.sashirestela.openai.domain.finetune.FineTuneEvent;
import io.github.sashirestela.openai.domain.finetune.FineTuneRequest;
import io.github.sashirestela.openai.domain.finetune.FineTuneResponse;
import io.github.sashirestela.openai.domain.image.ImageEditsRequest;
import io.github.sashirestela.openai.domain.image.ImageRequest;
import io.github.sashirestela.openai.domain.image.ImageResponse;
import io.github.sashirestela.openai.domain.image.ImageVariationsRequest;
import io.github.sashirestela.openai.domain.model.ModelResponse;
import io.github.sashirestela.openai.domain.moderation.ModerationRequest;
import io.github.sashirestela.openai.domain.moderation.ModerationResponse;
import io.github.sashirestela.openai.http.annotation.Body;
import io.github.sashirestela.openai.http.annotation.DELETE;
import io.github.sashirestela.openai.http.annotation.GET;
import io.github.sashirestela.openai.http.annotation.Multipart;
import io.github.sashirestela.openai.http.annotation.POST;
import io.github.sashirestela.openai.http.annotation.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

interface OpenAI {

    public static interface FineTunes {
        @POST(value="/v1/fine-tunes")
        public CompletableFuture<FineTuneResponse> create(@Body FineTuneRequest var1);

        @GET(value="/v1/fine-tunes")
        public CompletableFuture<List<FineTuneResponse>> getList();

        @GET(value="/v1/fine-tunes/{fineTuneId}")
        public CompletableFuture<FineTuneResponse> getOne(@Path(value="fineTuneId") String var1);

        @GET(value="/v1/fine-tunes/{fineTuneId}/events")
        public CompletableFuture<List<FineTuneEvent>> getEvents(@Path(value="fineTuneId") String var1);

        @POST(value="/v1/fine-tunes/{fineTuneId}/cancel")
        public CompletableFuture<FineTuneResponse> cancel(@Path(value="fineTuneId") String var1);
    }

    public static interface Moderations {
        @POST(value="/v1/moderations")
        public CompletableFuture<ModerationResponse> create(@Body ModerationRequest var1);
    }

    public static interface Models {
        @GET(value="/v1/models")
        public CompletableFuture<List<ModelResponse>> getList();

        @GET(value="/v1/models/{modelId}")
        public CompletableFuture<ModelResponse> getOne(@Path(value="modelId") String var1);
    }

    public static interface Images {
        @POST(value="/v1/images/generations")
        public CompletableFuture<List<ImageResponse>> create(@Body ImageRequest var1);

        @Multipart
        @POST(value="/v1/images/edits")
        public CompletableFuture<List<ImageResponse>> createEdits(@Body ImageEditsRequest var1);

        @Multipart
        @POST(value="/v1/images/variations")
        public CompletableFuture<List<ImageResponse>> createVariations(@Body ImageVariationsRequest var1);
    }

    public static interface Files {
        @Multipart
        @POST(value="/v1/files")
        public CompletableFuture<FileResponse> create(@Body FileRequest var1);

        @GET(value="/v1/files")
        public CompletableFuture<List<FileResponse>> getList();

        @GET(value="/v1/files/{fileId}")
        public CompletableFuture<FileResponse> getOne(@Path(value="fileId") String var1);

        @GET(value="/v1/files/{fileId}/content")
        public CompletableFuture<String> getContent(@Path(value="fileId") String var1);

        @DELETE(value="/v1/files/{fileId}")
        public CompletableFuture<FileDeletedResponse> delete(@Path(value="fileId") String var1);
    }

    public static interface Embeddings {
        @POST(value="/v1/embeddings")
        public CompletableFuture<EmbeddingResponse> create(@Body EmbeddingRequest var1);
    }

    public static interface Completions {
        @POST(value="/v1/completions")
        public CompletableFuture<CompletionResponse> create(@Body CompletionRequest var1);

        @POST(value="/v1/completions")
        public CompletableFuture<Stream<CompletionResponse>> createStream(@Body CompletionRequest var1);
    }

    public static interface ChatCompletions {
        @POST(value="/v1/chat/completions")
        public CompletableFuture<ChatResponse> create(@Body ChatRequest var1);

        @POST(value="/v1/chat/completions")
        public CompletableFuture<Stream<ChatResponse>> createStream(@Body ChatRequest var1);
    }

    public static interface Audios {
        @Multipart
        @POST(value="/v1/audio/transcriptions")
        public CompletableFuture<AudioResponse> transcribe(@Body AudioTranscribeRequest var1);

        @Multipart
        @POST(value="/v1/audio/translations")
        public CompletableFuture<AudioResponse> translate(@Body AudioTranslateRequest var1);

        @Multipart
        @POST(value="/v1/audio/transcriptions")
        public CompletableFuture<String> transcribePlain(@Body AudioTranscribeRequest var1);

        @Multipart
        @POST(value="/v1/audio/translations")
        public CompletableFuture<String> translatePlain(@Body AudioTranslateRequest var1);
    }
}

