/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.metadata;

import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.cleverclient.support.ReturnType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InterfaceMetadata {
    private static final String ANNOT_RESOURCE = "Resource";
    private static final String ANNOT_HEADER = "Header";
    private static final String ANNOT_MULTIPART = "Multipart";
    private static final String ANNOT_PARAM_BODY = "Body";
    private static final String ANNOT_PARAM_PATH = "Path";
    private static final String ANNOT_PARAM_QUERY = "Query";
    private static final String ANNOT_FIELD_NAME = "name";
    private static final String ANNOT_FIELD_VALUE = "value";
    private final String name;
    private final List<AnnotationMetadata> annotations;
    private final Map<String, MethodMetadata> methodBySignature;

    public String getFullUrlByMethod(MethodMetadata methodMetadata) {
        Optional<AnnotationMetadata> resourceAnnot = this.annotations.stream().filter(annot -> annot.getName().equals(ANNOT_RESOURCE)).findFirst();
        String resourceUrl = resourceAnnot.isPresent() ? resourceAnnot.get().getValue() : "";
        Optional<AnnotationMetadata> httpMethodAnnot = methodMetadata.getAnnotations().stream().filter(AnnotationMetadata::isHttpMethod).findFirst();
        String httpMethodUrl = httpMethodAnnot.isPresent() ? httpMethodAnnot.get().getValue() : "";
        return resourceUrl + httpMethodUrl;
    }

    public List<String> getFullHeadersByMethod(MethodMetadata methodMetadata) {
        List fullHeaderAnnots = this.annotations.stream().filter(annot -> annot.getName().equals(ANNOT_HEADER)).collect(Collectors.toList());
        List methodHeaderAnnots = methodMetadata.getAnnotations().stream().filter(annot -> annot.getName().equals(ANNOT_HEADER)).collect(Collectors.toList());
        fullHeaderAnnots.addAll(methodHeaderAnnots);
        ArrayList<String> fullHeaders = new ArrayList<String>();
        for (AnnotationMetadata annot2 : fullHeaderAnnots) {
            fullHeaders.add(annot2.getValueByField().get(ANNOT_FIELD_NAME));
            fullHeaders.add(annot2.getValueByField().get(ANNOT_FIELD_VALUE));
        }
        return fullHeaders;
    }

    @Generated
    InterfaceMetadata(String name, List<AnnotationMetadata> annotations, Map<String, MethodMetadata> methodBySignature) {
        this.name = name;
        this.annotations = annotations;
        this.methodBySignature = methodBySignature;
    }

    @Generated
    public static InterfaceMetadataBuilder builder() {
        return new InterfaceMetadataBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public Map<String, MethodMetadata> getMethodBySignature() {
        return this.methodBySignature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterfaceMetadata)) {
            return false;
        }
        InterfaceMetadata other = (InterfaceMetadata)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<AnnotationMetadata> this$annotations = this.getAnnotations();
        List<AnnotationMetadata> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Map<String, MethodMetadata> this$methodBySignature = this.getMethodBySignature();
        Map<String, MethodMetadata> other$methodBySignature = other.getMethodBySignature();
        return !(this$methodBySignature == null ? other$methodBySignature != null : !((Object)this$methodBySignature).equals(other$methodBySignature));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<AnnotationMetadata> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Map<String, MethodMetadata> $methodBySignature = this.getMethodBySignature();
        result = result * 59 + ($methodBySignature == null ? 43 : ((Object)$methodBySignature).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InterfaceMetadata(name=" + this.getName() + ", annotations=" + String.valueOf(this.getAnnotations()) + ", methodBySignature=" + String.valueOf(this.getMethodBySignature()) + ")";
    }

    @Generated
    public static class InterfaceMetadataBuilder {
        @Generated
        private String name;
        @Generated
        private List<AnnotationMetadata> annotations;
        @Generated
        private Map<String, MethodMetadata> methodBySignature;

        @Generated
        InterfaceMetadataBuilder() {
        }

        @Generated
        public InterfaceMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public InterfaceMetadataBuilder annotations(List<AnnotationMetadata> annotations) {
            this.annotations = annotations;
            return this;
        }

        @Generated
        public InterfaceMetadataBuilder methodBySignature(Map<String, MethodMetadata> methodBySignature) {
            this.methodBySignature = methodBySignature;
            return this;
        }

        @Generated
        public InterfaceMetadata build() {
            return new InterfaceMetadata(this.name, this.annotations, this.methodBySignature);
        }

        @Generated
        public String toString() {
            return "InterfaceMetadata.InterfaceMetadataBuilder(name=" + this.name + ", annotations=" + String.valueOf(this.annotations) + ", methodBySignature=" + String.valueOf(this.methodBySignature) + ")";
        }
    }

    public static final class AnnotationMetadata {
        private final String name;
        private final boolean isHttpMethod;
        private final Map<String, String> valueByField;

        public String getValue() {
            return this.valueByField.get(InterfaceMetadata.ANNOT_FIELD_VALUE);
        }

        @Generated
        AnnotationMetadata(String name, boolean isHttpMethod, Map<String, String> valueByField) {
            this.name = name;
            this.isHttpMethod = isHttpMethod;
            this.valueByField = valueByField;
        }

        @Generated
        public static AnnotationMetadataBuilder builder() {
            return new AnnotationMetadataBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean isHttpMethod() {
            return this.isHttpMethod;
        }

        @Generated
        public Map<String, String> getValueByField() {
            return this.valueByField;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotationMetadata)) {
                return false;
            }
            AnnotationMetadata other = (AnnotationMetadata)o;
            if (this.isHttpMethod() != other.isHttpMethod()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, String> this$valueByField = this.getValueByField();
            Map<String, String> other$valueByField = other.getValueByField();
            return !(this$valueByField == null ? other$valueByField != null : !((Object)this$valueByField).equals(other$valueByField));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHttpMethod() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, String> $valueByField = this.getValueByField();
            result = result * 59 + ($valueByField == null ? 43 : ((Object)$valueByField).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InterfaceMetadata.AnnotationMetadata(name=" + this.getName() + ", isHttpMethod=" + this.isHttpMethod() + ", valueByField=" + String.valueOf(this.getValueByField()) + ")";
        }

        @Generated
        public static class AnnotationMetadataBuilder {
            @Generated
            private String name;
            @Generated
            private boolean isHttpMethod;
            @Generated
            private Map<String, String> valueByField;

            @Generated
            AnnotationMetadataBuilder() {
            }

            @Generated
            public AnnotationMetadataBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public AnnotationMetadataBuilder isHttpMethod(boolean isHttpMethod) {
                this.isHttpMethod = isHttpMethod;
                return this;
            }

            @Generated
            public AnnotationMetadataBuilder valueByField(Map<String, String> valueByField) {
                this.valueByField = valueByField;
                return this;
            }

            @Generated
            public AnnotationMetadata build() {
                return new AnnotationMetadata(this.name, this.isHttpMethod, this.valueByField);
            }

            @Generated
            public String toString() {
                return "InterfaceMetadata.AnnotationMetadata.AnnotationMetadataBuilder(name=" + this.name + ", isHttpMethod=" + this.isHttpMethod + ", valueByField=" + String.valueOf(this.valueByField) + ")";
            }
        }
    }

    public static final class ParameterMetadata {
        private final int index;
        private final AnnotationMetadata annotation;

        @Generated
        ParameterMetadata(int index, AnnotationMetadata annotation) {
            this.index = index;
            this.annotation = annotation;
        }

        @Generated
        public static ParameterMetadataBuilder builder() {
            return new ParameterMetadataBuilder();
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public AnnotationMetadata getAnnotation() {
            return this.annotation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterMetadata)) {
                return false;
            }
            ParameterMetadata other = (ParameterMetadata)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            AnnotationMetadata this$annotation = this.getAnnotation();
            AnnotationMetadata other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !((Object)this$annotation).equals(other$annotation));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            AnnotationMetadata $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : ((Object)$annotation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InterfaceMetadata.ParameterMetadata(index=" + this.getIndex() + ", annotation=" + String.valueOf(this.getAnnotation()) + ")";
        }

        @Generated
        public static class ParameterMetadataBuilder {
            @Generated
            private int index;
            @Generated
            private AnnotationMetadata annotation;

            @Generated
            ParameterMetadataBuilder() {
            }

            @Generated
            public ParameterMetadataBuilder index(int index) {
                this.index = index;
                return this;
            }

            @Generated
            public ParameterMetadataBuilder annotation(AnnotationMetadata annotation) {
                this.annotation = annotation;
                return this;
            }

            @Generated
            public ParameterMetadata build() {
                return new ParameterMetadata(this.index, this.annotation);
            }

            @Generated
            public String toString() {
                return "InterfaceMetadata.ParameterMetadata.ParameterMetadataBuilder(index=" + this.index + ", annotation=" + String.valueOf(this.annotation) + ")";
            }
        }
    }

    public static final class MethodMetadata {
        private final String name;
        private final ReturnType returnType;
        private final boolean isDefault;
        private final List<AnnotationMetadata> annotations;
        private final List<ParameterMetadata> parameters;

        public boolean hasHttpAnnotation() {
            return this.annotations.stream().anyMatch(AnnotationMetadata::isHttpMethod);
        }

        public String getHttpAnnotationName() {
            return this.annotations.stream().filter(AnnotationMetadata::isHttpMethod).findFirst().get().getName();
        }

        public ContentType getContentType() {
            if (this.getBodyIndex() == -1) {
                return null;
            }
            return this.isMultipart() ? ContentType.MULTIPART_FORMDATA : ContentType.APPLICATION_JSON;
        }

        private boolean isMultipart() {
            return this.annotations.stream().anyMatch(annot -> annot.getName().equals(InterfaceMetadata.ANNOT_MULTIPART));
        }

        public int getBodyIndex() {
            Optional<ParameterMetadata> bodyParam = this.parameters.stream().filter(param -> param.getAnnotation().getName().equals(InterfaceMetadata.ANNOT_PARAM_BODY)).findFirst();
            return bodyParam.isPresent() ? bodyParam.get().getIndex() : -1;
        }

        public List<ParameterMetadata> getPathParameters() {
            return this.getParametersFilteredBy(InterfaceMetadata.ANNOT_PARAM_PATH);
        }

        public List<ParameterMetadata> getQueryParameters() {
            return this.getParametersFilteredBy(InterfaceMetadata.ANNOT_PARAM_QUERY);
        }

        private List<ParameterMetadata> getParametersFilteredBy(String annotationName) {
            return this.parameters.stream().filter(param -> param.getAnnotation() != null).filter(param -> param.getAnnotation().getName().equals(annotationName)).collect(Collectors.toList());
        }

        @Generated
        MethodMetadata(String name, ReturnType returnType, boolean isDefault, List<AnnotationMetadata> annotations, List<ParameterMetadata> parameters) {
            this.name = name;
            this.returnType = returnType;
            this.isDefault = isDefault;
            this.annotations = annotations;
            this.parameters = parameters;
        }

        @Generated
        public static MethodMetadataBuilder builder() {
            return new MethodMetadataBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public ReturnType getReturnType() {
            return this.returnType;
        }

        @Generated
        public boolean isDefault() {
            return this.isDefault;
        }

        @Generated
        public List<AnnotationMetadata> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public List<ParameterMetadata> getParameters() {
            return this.parameters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodMetadata)) {
                return false;
            }
            MethodMetadata other = (MethodMetadata)o;
            if (this.isDefault() != other.isDefault()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ReturnType this$returnType = this.getReturnType();
            ReturnType other$returnType = other.getReturnType();
            if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                return false;
            }
            List<AnnotationMetadata> this$annotations = this.getAnnotations();
            List<AnnotationMetadata> other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            List<ParameterMetadata> this$parameters = this.getParameters();
            List<ParameterMetadata> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDefault() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ReturnType $returnType = this.getReturnType();
            result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
            List<AnnotationMetadata> $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            List<ParameterMetadata> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InterfaceMetadata.MethodMetadata(name=" + this.getName() + ", returnType=" + String.valueOf(this.getReturnType()) + ", isDefault=" + this.isDefault() + ", annotations=" + String.valueOf(this.getAnnotations()) + ", parameters=" + String.valueOf(this.getParameters()) + ")";
        }

        @Generated
        public static class MethodMetadataBuilder {
            @Generated
            private String name;
            @Generated
            private ReturnType returnType;
            @Generated
            private boolean isDefault;
            @Generated
            private List<AnnotationMetadata> annotations;
            @Generated
            private List<ParameterMetadata> parameters;

            @Generated
            MethodMetadataBuilder() {
            }

            @Generated
            public MethodMetadataBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public MethodMetadataBuilder returnType(ReturnType returnType) {
                this.returnType = returnType;
                return this;
            }

            @Generated
            public MethodMetadataBuilder isDefault(boolean isDefault) {
                this.isDefault = isDefault;
                return this;
            }

            @Generated
            public MethodMetadataBuilder annotations(List<AnnotationMetadata> annotations) {
                this.annotations = annotations;
                return this;
            }

            @Generated
            public MethodMetadataBuilder parameters(List<ParameterMetadata> parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public MethodMetadata build() {
                return new MethodMetadata(this.name, this.returnType, this.isDefault, this.annotations, this.parameters);
            }

            @Generated
            public String toString() {
                return "InterfaceMetadata.MethodMetadata.MethodMetadataBuilder(name=" + this.name + ", returnType=" + String.valueOf(this.returnType) + ", isDefault=" + this.isDefault + ", annotations=" + String.valueOf(this.annotations) + ", parameters=" + String.valueOf(this.parameters) + ")";
            }
        }
    }
}

