/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.client;

import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.client.RequestData;
import io.github.sashirestela.cleverclient.client.ResponseData;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.cleverclient.support.HttpMultipart;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientAdapter
extends HttpClientAdapter {
    private static Logger logger = LoggerFactory.getLogger(OkHttpClientAdapter.class);
    private OkHttpClient okHttpClient;
    private EnumMap<ReturnType.Category, FunctionsByCategory> functionsByCategoryMap;

    public OkHttpClientAdapter(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        this.fillFunctionsByCategory();
    }

    public OkHttpClientAdapter() {
        this(new OkHttpClient());
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    @Override
    protected Object send(RequestData request) {
        Object object;
        block9: {
            ReturnType returnType = request.getReturnType();
            FunctionsByCategory functions = this.getFunctions(returnType);
            Request okHttpRequest = this.convertToOkHttpRequest(request);
            Response response = this.okHttpClient.newCall(okHttpRequest).execute();
            logger.debug("Response Code : {}", (Object)response.code());
            if (returnType.isStream() || returnType.isInputStream()) {
                Object responseContent = this.getResponseContent(response.body(), returnType);
                ResponseData originalResponseData = this.convertToResponseData(response, responseContent);
                this.throwExceptionIfErrorIsPresent(originalResponseData);
                ResponseData responseData = this.interceptResponse(originalResponseData);
                return functions.responseConverter.apply(responseData, returnType);
            }
            Response response2 = response;
            try {
                Object responseContent = this.getResponseContent(response.body(), returnType);
                ResponseData originalResponseData = this.convertToResponseData(response, responseContent);
                this.throwExceptionIfErrorIsPresent(originalResponseData);
                ResponseData responseData = this.interceptResponse(originalResponseData);
                logger.debug("Response : {}", responseData.getBody());
                object = functions.responseConverter.apply(responseData.getBody(), returnType);
                if (response2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CleverClientException(e);
                }
            }
            response2.close();
        }
        return object;
    }

    @Override
    protected Object sendAsync(RequestData request) {
        final ReturnType returnType = request.getReturnType();
        final FunctionsByCategory functions = this.getFunctions(returnType);
        Request okHttpRequest = this.convertToOkHttpRequest(request);
        final CompletableFuture responseFuture = new CompletableFuture();
        this.okHttpClient.newCall(okHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                responseFuture.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                logger.debug("Response Code : {}", (Object)response.code());
                if (returnType.isStream() || returnType.isInputStream()) {
                    try {
                        Object responseContent = OkHttpClientAdapter.this.getResponseContent(response.body(), returnType);
                        ResponseData originalResponseData = OkHttpClientAdapter.this.convertToResponseData(response, responseContent);
                        OkHttpClientAdapter.this.throwExceptionIfErrorIsPresent(originalResponseData);
                        ResponseData responseData = OkHttpClientAdapter.this.interceptResponse(originalResponseData);
                        responseFuture.complete(functions.responseConverter.apply(responseData, returnType));
                    }
                    catch (CleverClientException e) {
                        response.close();
                        responseFuture.completeExceptionally(e);
                    }
                } else {
                    try (Response e = response;){
                        Object responseContent = OkHttpClientAdapter.this.getResponseContent(response.body(), returnType);
                        ResponseData originalResponseData = OkHttpClientAdapter.this.convertToResponseData(response, responseContent);
                        OkHttpClientAdapter.this.throwExceptionIfErrorIsPresent(originalResponseData);
                        ResponseData responseData = OkHttpClientAdapter.this.interceptResponse(originalResponseData);
                        logger.debug("Response : {}", responseData.getBody());
                        responseFuture.complete(functions.responseConverter.apply(responseData.getBody(), returnType));
                    }
                    catch (CleverClientException e2) {
                        responseFuture.completeExceptionally(e2);
                    }
                }
            }
        });
        return responseFuture;
    }

    @Override
    public void shutdown() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
    }

    private FunctionsByCategory getFunctions(ReturnType returnType) {
        FunctionsByCategory functions = this.functionsByCategoryMap.get((Object)returnType.category());
        if (functions == null) {
            throw new CleverClientException("Unsupported return type {0}.", returnType.getFullClassName(), null);
        }
        return functions;
    }

    private Request convertToOkHttpRequest(RequestData request) {
        RequestBody requestBody = this.createRequestBody(request.getBody(), request.getContentType(), request.getHttpMethod());
        String[] headersArray = request.getHeaders().toArray(new String[0]);
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl()).method(request.getHttpMethod(), requestBody);
        if (headersArray.length > 0) {
            requestBuilder.headers(Headers.of((String[])headersArray));
        }
        return requestBuilder.build();
    }

    private RequestBody createRequestBody(Object bodyObject, ContentType contentType, String httpMethod) {
        RequestBody requestBody = null;
        if (contentType == null) {
            logger.debug("Request Body : {}", (Object)"(Empty)");
            if (httpMethod.equalsIgnoreCase("POST")) {
                requestBody = RequestBody.create((String)"", null);
            }
        } else if (contentType == ContentType.MULTIPART_FORMDATA) {
            logger.debug("Request Body : {}", bodyObject);
            List<byte[]> bodyBytes = HttpMultipart.toByteArrays((Map)bodyObject);
            requestBody = RequestBody.create((ByteString)ByteString.of((byte[])this.concatenateByteArrays(bodyBytes)), (MediaType)MediaType.parse((String)(contentType.getMimeType() + contentType.getDetails())));
        } else if (contentType == ContentType.APPLICATION_JSON) {
            logger.debug("Request Body : {}", bodyObject);
            requestBody = RequestBody.create((String)((String)bodyObject), (MediaType)MediaType.parse((String)contentType.getMimeType()));
        }
        return requestBody;
    }

    private byte[] concatenateByteArrays(List<byte[]> arrays) {
        int totalLength = arrays.stream().mapToInt(arr -> ((byte[])arr).length).sum();
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
        }
        return result;
    }

    private ResponseData convertToResponseData(Response response, Object responseContent) {
        Request request = response.request();
        return ResponseData.builder().statusCode(response.code()).body(responseContent).headers(response.headers().toMultimap()).request(request != null ? ResponseData.Request.builder().httpMethod(request.method()).url(request.url().toString()).headers(request.headers().toMultimap()).build() : null).build();
    }

    private Object getResponseContent(final ResponseBody responseBody, ReturnType returnType) {
        try {
            if (returnType.isStream()) {
                final BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody.byteStream()));
                return StreamSupport.stream(new Spliterator<String>(){
                    private final Iterator<String> iterator;
                    private boolean closed;
                    {
                        this.iterator = reader.lines().iterator();
                        this.closed = false;
                    }

                    @Override
                    public boolean tryAdvance(Consumer<? super String> action) {
                        if (this.iterator.hasNext()) {
                            action.accept(this.iterator.next());
                            return true;
                        }
                        if (!this.closed) {
                            try {
                                reader.close();
                                responseBody.close();
                                this.closed = true;
                            }
                            catch (Exception e) {
                                throw new CleverClientException(e);
                            }
                        }
                        return false;
                    }

                    @Override
                    public Spliterator<String> trySplit() {
                        return null;
                    }

                    @Override
                    public long estimateSize() {
                        return Long.MAX_VALUE;
                    }

                    @Override
                    public int characteristics() {
                        return 16;
                    }
                }, false);
            }
            if (returnType.isInputStream()) {
                return responseBody.byteStream();
            }
            return responseBody.string();
        }
        catch (IOException e) {
            throw new CleverClientException(e);
        }
    }

    private void fillFunctionsByCategory() {
        this.functionsByCategoryMap = new EnumMap(ReturnType.Category.class);
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_BINARY, new FunctionsByCategory((r, t) -> ((ResponseData)r).getBody()));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_PLAIN_TEXT, new FunctionsByCategory((r, t) -> r));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_CUSTOM, new FunctionsByCategory((r, t) -> JsonUtil.jsonToObject((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_GENERIC, new FunctionsByCategory((r, t) -> JsonUtil.jsonToParametricObject((String)r, t.getGenericClassIfExists(), t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_LIST, new FunctionsByCategory((r, t) -> JsonUtil.jsonToList((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_STREAM, new FunctionsByCategory((r, t) -> this.convertToStreamOfObjects((ResponseData)r, (ReturnType)t)));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_STREAM_EVENT, new FunctionsByCategory((r, t) -> this.convertToStreamOfEvents((ResponseData)r, (ReturnType)t)));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_BINARY, new FunctionsByCategory((r, t) -> ((ResponseData)r).getBody()));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_PLAIN_TEXT, new FunctionsByCategory((r, t) -> r));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_CUSTOM, new FunctionsByCategory((r, t) -> JsonUtil.jsonToObject((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_GENERIC, new FunctionsByCategory((r, t) -> JsonUtil.jsonToParametricObject((String)r, t.getGenericClassIfExists(), t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_LIST, new FunctionsByCategory((r, t) -> JsonUtil.jsonToList((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_STREAM, new FunctionsByCategory((r, t) -> this.convertToStreamOfObjects((ResponseData)r, (ReturnType)t)));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_STREAM_EVENT, new FunctionsByCategory((r, t) -> this.convertToStreamOfEvents((ResponseData)r, (ReturnType)t)));
    }

    private class FunctionsByCategory {
        BiFunction<Object, ReturnType, Object> responseConverter;

        public FunctionsByCategory(BiFunction<Object, ReturnType, Object> responseConverter) {
            this.responseConverter = responseConverter;
        }
    }
}

