/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.support.ContentType;
import java.util.Map;

public class HttpRequestData {
    private String url;
    private Object body;
    private Map<String, String> headers;
    private String httpMethod;
    private ContentType contentType;

    HttpRequestData(String url, Object body, Map<String, String> headers, String httpMethod, ContentType contentType) {
        this.url = url;
        this.body = body;
        this.headers = headers;
        this.httpMethod = httpMethod;
        this.contentType = contentType;
    }

    public static HttpRequestDataBuilder builder() {
        return new HttpRequestDataBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public Object getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public static class HttpRequestDataBuilder {
        private String url;
        private Object body;
        private Map<String, String> headers;
        private String httpMethod;
        private ContentType contentType;

        HttpRequestDataBuilder() {
        }

        public HttpRequestDataBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpRequestDataBuilder body(Object body) {
            this.body = body;
            return this;
        }

        public HttpRequestDataBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpRequestDataBuilder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public HttpRequestDataBuilder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public HttpRequestData build() {
            return new HttpRequestData(this.url, this.body, this.headers, this.httpMethod, this.contentType);
        }

        public String toString() {
            return "HttpRequestData.HttpRequestDataBuilder(url=" + this.url + ", body=" + this.body + ", headers=" + this.headers + ", httpMethod=" + this.httpMethod + ", contentType=" + this.contentType + ")";
        }
    }
}

