/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpSender {
    protected static Logger logger = LoggerFactory.getLogger(HttpSender.class);

    public abstract <S, T> Object sendRequest(HttpClient var1, HttpRequest var2, Class<T> var3, Class<S> var4);

    protected void throwExceptionIfErrorIsPresent(HttpResponse<?> response, Class<?> clazz) {
        logger.debug("Response Code : {}", (Object)response.statusCode());
        if (!CommonUtil.isInHundredsOf(response.statusCode(), 200)) {
            String data = "";
            if (Stream.class.equals(clazz)) {
                data = ((Stream)response.body()).collect(Collectors.joining(System.getProperty("line.separator")));
            } else if (InputStream.class.equals(clazz)) {
                try {
                    data = new String(((InputStream)response.body()).readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                data = (String)response.body();
            }
            logger.error("Response : {}", (Object)data);
            throw new CleverClientException("ERROR : {0}", data, null);
        }
    }
}

