/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.http.HttpMultipart;
import io.github.sashirestela.cleverclient.http.ReturnType;
import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.sender.HttpSenderFactory;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.cleverclient.util.ReflectUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    private HttpClient httpClient;
    private String url;
    private String httpMethod;
    private ReturnType returnType;
    private List<Object> bodyObjects;
    private boolean isMultipart;
    private String[] headersArray;

    public Object sendRequest() {
        HttpRequest.BodyPublisher bodyPublisher = this.createBodyPublisher(this.bodyObjects, this.isMultipart);
        Class<?> responseClass = this.returnType.getBaseClass();
        HttpRequest httpRequest = null;
        httpRequest = this.headersArray.length > 0 ? HttpRequest.newBuilder().uri(URI.create(this.url)).headers(this.headersArray).method(this.httpMethod, bodyPublisher).build() : HttpRequest.newBuilder().uri(URI.create(this.url)).method(this.httpMethod, bodyPublisher).build();
        HttpSender httpSender = HttpSenderFactory.get().createSender(this.returnType);
        if (this.returnType.isGeneric()) {
            return httpSender.sendRequest(this.httpClient, httpRequest, responseClass, this.returnType.getGenericClass());
        }
        return httpSender.sendRequest(this.httpClient, httpRequest, responseClass, null);
    }

    private HttpRequest.BodyPublisher createBodyPublisher(List<Object> bodyObjects, boolean isMultipart) {
        HttpRequest.BodyPublisher bodyPublisher = null;
        if (bodyObjects.isEmpty()) {
            logger.debug("Body Request: (Empty)");
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        } else if (isMultipart) {
            Map<String, Object> data = ReflectUtil.getMapFields(bodyObjects);
            List<byte[]> requestBytes = HttpMultipart.toByteArrays(data);
            logger.debug("Body Request: {}", data);
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArrays(requestBytes);
        } else {
            String requestString = JsonUtil.objectsToJson(bodyObjects);
            logger.debug("Body Request: {}", (Object)requestString);
            bodyPublisher = HttpRequest.BodyPublishers.ofString(requestString);
        }
        return bodyPublisher;
    }

    public static HttpConnectorBuilder builder() {
        return new HttpConnectorBuilder();
    }

    public HttpConnector(HttpClient httpClient, String url, String httpMethod, ReturnType returnType, List<Object> bodyObjects, boolean isMultipart, String[] headersArray) {
        this.httpClient = httpClient;
        this.url = url;
        this.httpMethod = httpMethod;
        this.returnType = returnType;
        this.bodyObjects = bodyObjects;
        this.isMultipart = isMultipart;
        this.headersArray = headersArray;
    }

    public static class HttpConnectorBuilder {
        private HttpClient httpClient;
        private String url;
        private String httpMethod;
        private ReturnType returnType;
        private List<Object> bodyObjects;
        private boolean isMultipart;
        private String[] headersArray;

        HttpConnectorBuilder() {
        }

        public HttpConnectorBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HttpConnectorBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpConnectorBuilder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public HttpConnectorBuilder returnType(ReturnType returnType) {
            this.returnType = returnType;
            return this;
        }

        public HttpConnectorBuilder bodyObjects(List<Object> bodyObjects) {
            this.bodyObjects = bodyObjects;
            return this;
        }

        public HttpConnectorBuilder isMultipart(boolean isMultipart) {
            this.isMultipart = isMultipart;
            return this;
        }

        public HttpConnectorBuilder headersArray(String[] headersArray) {
            this.headersArray = headersArray;
            return this;
        }

        public HttpConnector build() {
            return new HttpConnector(this.httpClient, this.url, this.httpMethod, this.returnType, this.bodyObjects, this.isMultipart, this.headersArray);
        }

        public String toString() {
            return "HttpConnector.HttpConnectorBuilder(httpClient=" + this.httpClient + ", url=" + this.url + ", httpMethod=" + this.httpMethod + ", returnType=" + this.returnType + ", bodyObjects=" + this.bodyObjects + ", isMultipart=" + this.isMultipart + ", headersArray=" + Arrays.deepToString(this.headersArray) + ")";
        }
    }
}

