/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.Constant;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpMultipart {
    private static final String DASH = "--";
    private static final String DQ = "\"";
    private static final String NL = "\r\n";
    private static final String DISPOSITION = "Content-Disposition: form-data";
    private static final String FIELD_NAME = "; name=";
    private static final String FILE_NAME = "; filename=";
    private static final String CONTENT_TYPE = "Content-Type: ";

    private HttpMultipart() {
    }

    public static List<byte[]> toByteArrays(Map<String, Object> data) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            byteArrays.add(HttpMultipart.toBytes(DASH + Constant.BOUNDARY_VALUE + NL));
            byteArrays.add(HttpMultipart.toBytes(DISPOSITION));
            String fieldName = entry.getKey();
            if (entry.getValue() instanceof Path) {
                String fileName = null;
                String mimeType = null;
                byte[] fileContent = null;
                try {
                    Path path = (Path)entry.getValue();
                    fileName = path.toString();
                    mimeType = Files.probeContentType(path);
                    fileContent = Files.readAllBytes(path);
                }
                catch (IOException e) {
                    throw new CleverClientException("Error trying to read the file {0}.", fileName, e);
                }
                byteArrays.add(HttpMultipart.toBytes("; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"\r\n"));
                byteArrays.add(HttpMultipart.toBytes(CONTENT_TYPE + mimeType + NL));
                byteArrays.add(HttpMultipart.toBytes(NL));
                byteArrays.add(fileContent);
                byteArrays.add(HttpMultipart.toBytes(NL));
                continue;
            }
            Object fieldValue = entry.getValue();
            byteArrays.add(HttpMultipart.toBytes("; name=\"" + fieldName + "\"\r\n"));
            byteArrays.add(HttpMultipart.toBytes(NL));
            byteArrays.add(HttpMultipart.toBytes(fieldValue + NL));
        }
        byteArrays.add(HttpMultipart.toBytes(DASH + Constant.BOUNDARY_VALUE + "--\r\n"));
        return byteArrays;
    }

    private static byte[] toBytes(String text) {
        return text.getBytes(StandardCharsets.UTF_8);
    }
}

