/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import io.github.sashirestela.cleverclient.http.HttpProcessor;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleverClient {
    private static final Logger logger = LoggerFactory.getLogger(CleverClient.class);
    private final String baseUrl;
    @Deprecated
    private final String urlBase;
    private final List<String> headers;
    private final HttpClient httpClient;
    private final HttpProcessor httpProcessor;

    public CleverClient(String baseUrl, String urlBase, List<String> headers, HttpClient httpClient, String endOfStream) {
        this.urlBase = null;
        if (CommonUtil.isNullOrEmpty(baseUrl) && CommonUtil.isNullOrEmpty(urlBase)) {
            throw new CleverClientException("At least one of baseUrl and urlBase is mandatory.", null, null);
        }
        this.baseUrl = CommonUtil.isNullOrEmpty(baseUrl) ? urlBase : baseUrl;
        this.headers = Optional.ofNullable(headers).orElse(List.of());
        if (this.headers.size() % 2 > 0) {
            throw new CleverClientException("Headers must be entered as pair of values in the list.", null, null);
        }
        this.httpClient = Optional.ofNullable(httpClient).orElse(HttpClient.newHttpClient());
        CleverClientSSE.setEndOfStream(endOfStream);
        this.httpProcessor = new HttpProcessor(this.baseUrl, this.headers, this.httpClient);
        logger.debug("CleverClient has been created.");
    }

    public <T> T create(Class<T> interfaceClass) {
        return this.httpProcessor.createProxy(interfaceClass);
    }

    public static CleverClientBuilder builder() {
        return new CleverClientBuilder();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Deprecated
    public String getUrlBase() {
        return this.urlBase;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public static class CleverClientBuilder {
        private String baseUrl;
        private String urlBase;
        private ArrayList<String> headers;
        private HttpClient httpClient;
        private String endOfStream;

        CleverClientBuilder() {
        }

        public CleverClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public CleverClientBuilder urlBase(String urlBase) {
            this.urlBase = urlBase;
            return this;
        }

        public CleverClientBuilder header(String header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public CleverClientBuilder headers(Collection<? extends String> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public CleverClientBuilder clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public CleverClientBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CleverClientBuilder endOfStream(String endOfStream) {
            this.endOfStream = endOfStream;
            return this;
        }

        public CleverClient build() {
            List<String> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<String>(this.headers));
                }
            }
            return new CleverClient(this.baseUrl, this.urlBase, headers, this.httpClient, this.endOfStream);
        }

        public String toString() {
            return "CleverClient.CleverClientBuilder(baseUrl=" + this.baseUrl + ", urlBase=" + this.urlBase + ", headers=" + this.headers + ", httpClient=" + this.httpClient + ", endOfStream=" + this.endOfStream + ")";
        }
    }
}

