/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class HttpAsyncStreamSender
extends HttpSender {
    @Override
    public <S, T> Object sendRequest(HttpClient httpClient, HttpRequest httpRequest, Class<T> responseClass, Class<S> genericClass) {
        CompletableFuture<HttpResponse<Stream<String>>> httpResponseFuture = httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofLines());
        return httpResponseFuture.thenApply(response -> {
            this.throwExceptionIfErrorIsPresent((HttpResponse<?>)response, Stream.class);
            return ((Stream)response.body()).peek(rawData -> logger.debug("Response : {}", rawData)).map(CleverClientSSE::new).filter(CleverClientSSE::isActualData).map(event -> JsonUtil.jsonToObject(event.getActualData(), responseClass));
        });
    }
}

