/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.metadata;

import io.github.sashirestela.cleverclient.ReturnType;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.cleverclient.metadata.Metadata;
import io.github.sashirestela.cleverclient.util.Constant;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCollector {
    private static Logger logger = LoggerFactory.getLogger(MetadataCollector.class);

    private MetadataCollector() {
    }

    public static MetadataCollector get() {
        return SingletonHelper.INSTANCE;
    }

    public Metadata collect(Class<?> clazz) {
        Method[] methods;
        String urlFromResource = Optional.ofNullable(this.getAnnotValue(clazz.getAnnotation(Resource.class))).orElse("");
        HashMap<String, Metadata.Method> methodsMap = new HashMap<String, Metadata.Method>();
        for (Method method : methods = clazz.getMethods()) {
            String fullClassName = method.getGenericReturnType().getTypeName();
            List<Metadata.Annotation> methodAnnotsList = this.getAnnotationsMetadata(method.getDeclaredAnnotations());
            Metadata.Annotation httpAnnotation = this.getAnnotIfIsInList(methodAnnotsList, Constant.HTTP_METHODS);
            boolean isMultipart = this.getAnnotIfIsInList(methodAnnotsList, Constant.MULTIPART_AS_LIST) != null;
            String urlFromHttp = httpAnnotation != null ? httpAnnotation.getValue() : "";
            Map<String, List<Metadata.Parameter>> parametersByType = this.getParametersByType(method.getParameters());
            Metadata.Method methodMetadata = Metadata.Method.builder().name(method.getName()).returnType(new ReturnType(fullClassName)).httpAnnotation(httpAnnotation).isMultipart(isMultipart).url(urlFromResource + urlFromHttp).parametersByType(parametersByType).build();
            methodsMap.put(method.getName(), methodMetadata);
        }
        Metadata metadata = Metadata.builder().name(clazz.getSimpleName()).methods(methodsMap).build();
        logger.debug("Collected Metadata");
        return metadata;
    }

    private Map<String, List<Metadata.Parameter>> getParametersByType(Parameter[] parameters) {
        HashMap<String, List<Metadata.Parameter>> parametersByType = new HashMap<String, List<Metadata.Parameter>>();
        for (String paramType : Constant.PARAMETER_TYPES) {
            parametersByType.put(paramType, new ArrayList());
        }
        int index = 0;
        for (Parameter parameter : parameters) {
            Annotation[] annotations = parameter.getDeclaredAnnotations();
            if (annotations.length > 0) {
                Annotation annotation = annotations[0];
                String annotationValue = this.getAnnotValue(annotation);
                Metadata.Parameter paramMetadata = Metadata.Parameter.builder().index(index).type(parameter.getType()).annotationValue(annotationValue).build();
                String annotationName = annotation.annotationType().getSimpleName();
                parametersByType.computeIfPresent(annotationName, (key, val) -> {
                    val.add(paramMetadata);
                    return val;
                });
            }
            ++index;
        }
        return parametersByType;
    }

    private List<Metadata.Annotation> getAnnotationsMetadata(Annotation[] annotations) {
        ArrayList<Metadata.Annotation> annotationsMetadata = new ArrayList<Metadata.Annotation>();
        for (Annotation annotation : annotations) {
            String annotName = annotation.annotationType().getSimpleName();
            String annotValue = this.getAnnotValue(annotation);
            annotationsMetadata.add(new Metadata.Annotation(annotName, annotValue));
        }
        return annotationsMetadata;
    }

    private String getAnnotValue(Annotation annotation) {
        Object value;
        if (annotation == null) {
            return null;
        }
        Class<? extends Annotation> annotType = annotation.annotationType();
        try {
            Method annotAttrib = annotType.getMethod("value", new Class[0]);
            value = annotAttrib.invoke((Object)annotation, (Object[])null);
        }
        catch (Exception e) {
            value = null;
        }
        return (String)value;
    }

    private Metadata.Annotation getAnnotIfIsInList(List<Metadata.Annotation> annotations, List<String> annotationNames) {
        if (annotations.isEmpty()) {
            return null;
        }
        return annotations.stream().filter(annot -> annotationNames.contains(annot.getName())).findFirst().orElse(null);
    }

    private static class SingletonHelper {
        private static final MetadataCollector INSTANCE = new MetadataCollector();

        private SingletonHelper() {
        }
    }
}

