/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.picker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.sangcomz.fishbun.BaseActivity;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.adapter.view.PickerGridAdapter;
import com.sangcomz.fishbun.bean.Album;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.permission.PermissionCheck;
import com.sangcomz.fishbun.ui.picker.PickerController;
import com.sangcomz.fishbun.util.RadioWithTextButton;
import com.sangcomz.fishbun.util.SingleMediaScanner;
import com.sangcomz.fishbun.util.SquareFrameLayout;
import com.sangcomz.fishbun.util.UiUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PickerActivity
extends BaseActivity {
    private static final String TAG = "PickerActivity";
    private RecyclerView recyclerView;
    private PickerController pickerController;
    private Album album;
    private int position;
    private PickerGridAdapter adapter;
    private GridLayoutManager layoutManager;

    private void initValue() {
        Intent intent = this.getIntent();
        this.album = (Album)intent.getParcelableExtra(Define.BUNDLE_NAME.ALBUM.name());
        this.position = intent.getIntExtra(Define.BUNDLE_NAME.POSITION.name(), -1);
    }

    protected void onSaveInstanceState(Bundle outState) {
        try {
            outState.putString(this.define.SAVE_INSTANCE_SAVED_IMAGE, this.pickerController.getSavePath());
            outState.putParcelableArrayList(this.define.SAVE_INSTANCE_NEW_IMAGES, this.pickerController.getAddImagePaths());
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle outState) {
        super.onRestoreInstanceState(outState);
        try {
            ArrayList addImages = outState.getParcelableArrayList(this.define.SAVE_INSTANCE_NEW_IMAGES);
            String savedImage = outState.getString(this.define.SAVE_INSTANCE_SAVED_IMAGE);
            this.setAdapter(this.fishton.getPickerImages());
            if (addImages != null) {
                this.pickerController.setAddImagePaths(addImages);
            }
            if (savedImage != null) {
                this.pickerController.setSavePath(savedImage);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_picker);
        this.initController();
        this.initValue();
        this.initView();
        if (this.pickerController.checkPermission()) {
            this.pickerController.displayImage(this.album.bucketId, this.fishton.getExceptMimeTypeList(), this.fishton.getSpecifyFolderList());
        }
    }

    public void onBackPressed() {
        this.transImageFinish(this.position);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.define.TAKE_A_PICK_REQUEST_CODE) {
            if (resultCode == -1) {
                File savedFile = new File(this.pickerController.getSavePath());
                new SingleMediaScanner((Context)this, savedFile);
                this.adapter.addImage(Uri.fromFile((File)savedFile));
            } else {
                new File(this.pickerController.getSavePath()).delete();
            }
        } else if (requestCode == this.define.ENTER_DETAIL_REQUEST_CODE && resultCode == -1) {
            if (this.fishton.isAutomaticClose() && this.fishton.getSelectedImages().size() == this.fishton.getMaxCount()) {
                this.finishActivity();
            }
            this.refreshThumb();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 28: {
                if (grantResults.length <= 0) break;
                if (grantResults[0] == 0) {
                    this.pickerController.displayImage(this.album.bucketId, this.fishton.getExceptMimeTypeList(), this.fishton.getSpecifyFolderList());
                    break;
                }
                new PermissionCheck((Context)this).showPermissionDialog();
                this.finish();
                break;
            }
            case 29: {
                if (grantResults.length <= 0) break;
                if (grantResults[0] == 0) {
                    this.pickerController.takePicture((Activity)this, this.pickerController.getPathDir(this.album.bucketId));
                    break;
                }
                new PermissionCheck((Context)this).showPermissionDialog();
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        SpannableString spanString;
        this.getMenuInflater().inflate(R.menu.menu_photo_album, menu2);
        MenuItem menuDoneItem = menu2.findItem(R.id.action_done);
        MenuItem menuAllDoneItem = menu2.findItem(R.id.action_all_done);
        if (this.fishton.getDrawableDoneButton() != null) {
            menuDoneItem.setIcon(this.fishton.getDrawableDoneButton());
        } else if (this.fishton.getStrDoneMenu() != null) {
            if (this.fishton.getColorTextMenu() != Integer.MAX_VALUE) {
                spanString = new SpannableString((CharSequence)this.fishton.getStrDoneMenu());
                spanString.setSpan((Object)new ForegroundColorSpan(this.fishton.getColorTextMenu()), 0, spanString.length(), 0);
                menuDoneItem.setTitle((CharSequence)spanString);
            } else {
                menuDoneItem.setTitle((CharSequence)this.fishton.getStrDoneMenu());
            }
            menuDoneItem.setIcon(null);
        }
        if (this.fishton.isUseAllDoneButton()) {
            menuAllDoneItem.setVisible(true);
            if (this.fishton.getDrawableAllDoneButton() != null) {
                menuAllDoneItem.setIcon(this.fishton.getDrawableAllDoneButton());
            } else if (this.fishton.getStrAllDoneMenu() != null) {
                if (this.fishton.getColorTextMenu() != Integer.MAX_VALUE) {
                    spanString = new SpannableString((CharSequence)this.fishton.getStrAllDoneMenu());
                    spanString.setSpan((Object)new ForegroundColorSpan(this.fishton.getColorTextMenu()), 0, spanString.length(), 0);
                    menuAllDoneItem.setTitle((CharSequence)spanString);
                } else {
                    menuAllDoneItem.setTitle((CharSequence)this.fishton.getStrAllDoneMenu());
                }
                menuAllDoneItem.setIcon(null);
            }
        } else {
            menuAllDoneItem.setVisible(false);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_done) {
            if (this.fishton.getSelectedImages().size() < this.fishton.getMinCount()) {
                Snackbar.make((View)this.recyclerView, (CharSequence)this.fishton.getMessageNothingSelected(), (int)-1).show();
            } else {
                this.finishActivity();
            }
            return true;
        }
        if (id2 == R.id.action_all_done) {
            for (Uri pickerImage : this.fishton.getPickerImages()) {
                if (this.fishton.getSelectedImages().size() == this.fishton.getMaxCount()) break;
                if (this.fishton.getSelectedImages().contains(pickerImage)) continue;
                this.fishton.getSelectedImages().add(pickerImage);
            }
            this.finishActivity();
        } else if (id2 == 16908332) {
            this.transImageFinish(this.position);
        }
        return super.onOptionsItemSelected(item);
    }

    public void showToolbarTitle(int total) {
        if (this.getSupportActionBar() != null) {
            if (this.fishton.getMaxCount() == 1 || !this.fishton.isShowCount()) {
                this.getSupportActionBar().setTitle((CharSequence)this.album.bucketName);
            } else {
                this.getSupportActionBar().setTitle((CharSequence)(this.album.bucketName + " (" + total + "/" + this.fishton.getMaxCount() + ")"));
            }
        }
    }

    private void initController() {
        this.pickerController = new PickerController(this);
    }

    private void initView() {
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_picker_list);
        this.layoutManager = new GridLayoutManager((Context)this, this.fishton.getPhotoSpanCount(), 1, false);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.initToolBar();
    }

    private void initToolBar() {
        ActionBar bar;
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_picker_bar);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(this.fishton.getColorActionBar());
        toolbar.setTitleTextColor(this.fishton.getColorActionBarTitle());
        if (Build.VERSION.SDK_INT >= 21) {
            UiUtil.setStatusBarColor((Activity)this, this.fishton.getColorStatusBar());
        }
        if ((bar = this.getSupportActionBar()) != null) {
            bar.setDisplayHomeAsUpEnabled(true);
            if (this.fishton.getDrawableHomeAsUpIndicator() != null) {
                this.getSupportActionBar().setHomeAsUpIndicator(this.fishton.getDrawableHomeAsUpIndicator());
            }
        }
        if (this.fishton.isStatusBarLight() && Build.VERSION.SDK_INT >= 23) {
            toolbar.setSystemUiVisibility(8192);
        }
        this.showToolbarTitle(0);
    }

    public void setAdapter(List<Uri> result) {
        this.fishton.setPickerImages(result);
        if (this.adapter == null) {
            this.adapter = new PickerGridAdapter(this.pickerController, this.pickerController.getPathDir(this.album.bucketId));
            this.adapter.setActionListener(new PickerGridAdapter.OnPhotoActionListener(){

                @Override
                public void onDeselect() {
                    PickerActivity.this.refreshThumb();
                }
            });
        }
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.showToolbarTitle(this.fishton.getSelectedImages().size());
    }

    private void refreshThumb() {
        int firstVisible = this.layoutManager.findFirstVisibleItemPosition();
        int lastVisible = this.layoutManager.findLastVisibleItemPosition();
        for (int i = firstVisible; i <= lastVisible; ++i) {
            View view = this.layoutManager.findViewByPosition(i);
            if (!(view instanceof SquareFrameLayout)) continue;
            SquareFrameLayout item = (SquareFrameLayout)view;
            RadioWithTextButton btnThumbCount = (RadioWithTextButton)item.findViewById(R.id.btn_thumb_count);
            ImageView imgThumbImage = (ImageView)item.findViewById(R.id.img_thumb_image);
            Uri image = (Uri)item.getTag();
            if (image == null) continue;
            int index = this.fishton.getSelectedImages().indexOf(image);
            if (index != -1) {
                this.adapter.updateRadioButton(imgThumbImage, btnThumbCount, String.valueOf(index + 1), true);
                continue;
            }
            this.adapter.updateRadioButton(imgThumbImage, btnThumbCount, "", false);
            this.showToolbarTitle(this.fishton.getSelectedImages().size());
        }
    }

    void transImageFinish(int position) {
        Define define = new Define();
        Intent i = new Intent();
        i.putParcelableArrayListExtra(define.INTENT_ADD_PATH, this.pickerController.getAddImagePaths());
        i.putExtra(define.INTENT_POSITION, position);
        define.getClass();
        this.setResult(29, i);
        this.finish();
    }

    public void finishActivity() {
        Intent i = new Intent();
        this.setResult(-1, i);
        if (this.fishton.isStartInAllView()) {
            i.putParcelableArrayListExtra("intent_path", this.fishton.getSelectedImages());
        }
        this.finish();
    }
}

