/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.github.robwin.swagger.test.SwaggerAssertionConfig;
import io.github.robwin.swagger.test.SwaggerAssertionType;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.SoftAssertions;

public class PropertyValidator {
    private static final String[] BASIC_PROPERTIES = new String[]{"type", "format", "allowEmptyValue", "name", "required", "readOnly", "access", "vendorExtensions"};
    private SwaggerAssertionConfig assertionConfig;
    private SoftAssertions softAssertions;

    public PropertyValidator(SwaggerAssertionConfig assertionConfig, SoftAssertions softAssertions) {
        this.assertionConfig = assertionConfig;
        this.softAssertions = softAssertions;
    }

    void validateProperty(Property actualProperty, Property expectedProperty, String message) {
        if (expectedProperty == null || !this.isAssertionEnabled(SwaggerAssertionType.PROPERTIES)) {
            return;
        }
        if (this.shouldValidateRefProperty(expectedProperty)) {
            this.validateBasicPropertyFeatures(actualProperty, expectedProperty, message);
        } else if (this.shouldValidateArrayProperty(expectedProperty)) {
            this.validateBasicPropertyFeatures(actualProperty, expectedProperty, message);
        } else if (this.shouldValidateByteArrayProperty(expectedProperty)) {
            this.validateBasicPropertyFeatures(actualProperty, expectedProperty, message);
        } else if (this.shouldValidateStringProperty(expectedProperty)) {
            StringProperty expectedStringProperty = (StringProperty)expectedProperty;
            this.validateBasicPropertyFeatures(actualProperty, expectedProperty, message);
            if (this.isPropertyOfEnumType(actualProperty)) {
                StringProperty actualStringProperty = (StringProperty)actualProperty;
                this.validateEnumPropertyFeatures(actualStringProperty, expectedStringProperty);
            }
        } else {
            this.validateBasicPropertyFeatures(actualProperty, expectedProperty, message);
        }
    }

    private boolean shouldValidateRefProperty(Property expectedProperty) {
        return RefProperty.class.isAssignableFrom(expectedProperty.getClass()) && this.isAssertionEnabled(SwaggerAssertionType.REF_PROPERTIES);
    }

    private boolean shouldValidateArrayProperty(Property expectedProperty) {
        return ArrayProperty.class.isAssignableFrom(expectedProperty.getClass()) && this.isAssertionEnabled(SwaggerAssertionType.ARRAY_PROPERTIES);
    }

    private boolean shouldValidateByteArrayProperty(Property expectedProperty) {
        return ByteArrayProperty.class.isAssignableFrom(expectedProperty.getClass()) && this.isAssertionEnabled(SwaggerAssertionType.BYTE_ARRAY_PROPERTIES);
    }

    private boolean shouldValidateStringProperty(Property expectedProperty) {
        return StringProperty.class.isAssignableFrom(expectedProperty.getClass()) && this.isAssertionEnabled(SwaggerAssertionType.STRING_PROPERTIES);
    }

    private boolean isAssertionEnabled(SwaggerAssertionType assertionType) {
        return this.assertionConfig.swaggerAssertionEnabled(assertionType);
    }

    private void validateBasicPropertyFeatures(Property actualProperty, Property expectedProperty, String message) {
        ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isExactlyInstanceOf(expectedProperty.getClass());
        ((ProxyableObjectAssert)this.softAssertions.assertThat((Object)actualProperty).as(message, new Object[0])).isEqualToComparingOnlyGivenFields((Object)expectedProperty, BASIC_PROPERTIES);
    }

    private boolean isPropertyOfEnumType(Property property) {
        return property != null && StringProperty.class.isAssignableFrom(property.getClass()) && CollectionUtils.isNotEmpty((Collection)((StringProperty)property).getEnum());
    }

    private void validateEnumPropertyFeatures(StringProperty actualStringProperty, StringProperty expectedStringProperty) {
        List expectedEnums = expectedStringProperty.getEnum();
        if (CollectionUtils.isNotEmpty((Collection)expectedEnums)) {
            this.softAssertions.assertThat(actualStringProperty.getEnum()).hasSameElementsAs((Iterable)expectedEnums);
        } else {
            this.softAssertions.assertThat(actualStringProperty.getEnum()).isNullOrEmpty();
        }
    }
}

