/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview.link;

import android.content.Intent;
import android.net.Uri;
import com.harissk.pdfpreview.PDFView;
import com.harissk.pdfpreview.link.LinkHandler;
import com.harissk.pdfpreview.model.LinkTapEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/harissk/pdfpreview/link/DefaultLinkHandler;", "Lcom/harissk/pdfpreview/link/LinkHandler;", "pdfView", "Lcom/harissk/pdfpreview/PDFView;", "(Lcom/harissk/pdfpreview/PDFView;)V", "handleLinkEvent", "", "event", "Lcom/harissk/pdfpreview/model/LinkTapEvent;", "handleUri", "uri", "", "pdfpreview_release"})
public final class DefaultLinkHandler
implements LinkHandler {
    @NotNull
    private final PDFView pdfView;

    public DefaultLinkHandler(@NotNull PDFView pdfView) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfView), (String)"pdfView");
        this.pdfView = pdfView;
    }

    @Override
    public void handleLinkEvent(@NotNull LinkTapEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getLink().getUri() != null) {
            String string = event.getLink().getUri();
            Intrinsics.checkNotNull((Object)string);
            this.handleUri(string);
        } else if (event.getLink().getDestPageIdx() != null) {
            Integer n = event.getLink().getDestPageIdx();
            Intrinsics.checkNotNull((Object)n);
            PDFView.jumpTo$default(this.pdfView, n, false, false, 6, null);
        }
    }

    private final void handleUri(String uri) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        if (intent.resolveActivity(this.pdfView.getContext().getPackageManager()) == null) {
            return;
        }
        this.pdfView.getContext().startActivity(intent);
    }
}

