/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview;

import android.content.Context;
import android.graphics.RectF;
import com.harissk.pdfium.exception.PageRenderingException;
import com.harissk.pdfium.listener.LogWriter;
import com.harissk.pdfium.util.SizeF;
import com.harissk.pdfpreview.PDFView;
import com.harissk.pdfpreview.RenderingHandler;
import com.harissk.pdfpreview.utils.UtilKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0004,-./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0002J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010#\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0002J\u0006\u0010)\u001a\u00020\u0012J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0006H\u0002J\b\u0010+\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/harissk/pdfpreview/PagesLoader;", "", "pdfView", "Lcom/harissk/pdfpreview/PDFView;", "(Lcom/harissk/pdfpreview/PDFView;)V", "cacheOrder", "", "pageRelativePartHeight", "", "pageRelativePartWidth", "partRenderHeight", "partRenderWidth", "preloadOffset", "thumbnailRect", "Landroid/graphics/RectF;", "xOffset", "yOffset", "calculatePartSize", "", "grid", "Lcom/harissk/pdfpreview/PagesLoader$GridSize;", "getPageColsRows", "pageIndex", "getRenderRangeList", "", "Lcom/harissk/pdfpreview/PagesLoader$RenderRange;", "firstXOffset", "firstYOffset", "lastXOffset", "lastYOffset", "loadCell", "", "page", "row", "col", "loadPage", "firstRow", "lastRow", "firstCol", "lastCol", "nbOfPartsLoadable", "loadPages", "loadThumbnail", "loadVisible", "Companion", "GridSize", "Holder", "RenderRange", "pdfpreview_release"})
@SourceDebugExtension(value={"SMAP\nPagesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagesLoader.kt\ncom/harissk/pdfpreview/PagesLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,550:1\n1#2:551\n1002#3,2:552\n*S KotlinDebug\n*F\n+ 1 PagesLoader.kt\ncom/harissk/pdfpreview/PagesLoader\n*L\n446#1:552,2\n*E\n"})
public final class PagesLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PDFView pdfView;
    private int cacheOrder;
    private float xOffset;
    private float yOffset;
    private float pageRelativePartWidth;
    private float pageRelativePartHeight;
    private float partRenderWidth;
    private float partRenderHeight;
    @NotNull
    private final RectF thumbnailRect;
    private final int preloadOffset;
    @NotNull
    private static final String TAG = "PagesLoader";

    public PagesLoader(@NotNull PDFView pdfView) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfView), (String)"pdfView");
        this.pdfView = pdfView;
        this.thumbnailRect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        Context context = this.pdfView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.preloadOffset = UtilKt.toPx(context, this.pdfView.getPdfViewerConfiguration().getPreloadMarginDp());
    }

    private final void getPageColsRows(GridSize grid, int pageIndex) {
        SizeF sizeF = this.pdfView.getPdfFile().getPageSize(pageIndex);
        if (sizeF == null) {
            return;
        }
        SizeF size = sizeF;
        if (size.getWidth() <= 0.0f || size.getHeight() <= 0.0f) {
            grid.setRows(1);
            grid.setCols(1);
            return;
        }
        float ratioX = 1.0f / size.getWidth();
        float ratioY = 1.0f / size.getHeight();
        float zoomFactor = RangesKt.coerceAtLeast((float)this.pdfView.getZoom(), (float)1.0f);
        float effectiveTileSize = this.pdfView.getPdfViewerConfiguration().getRenderTileSize() * (zoomFactor >= 3.0f ? zoomFactor * 1.5f : (zoomFactor >= 2.0f ? zoomFactor * 1.25f : (zoomFactor > 1.0f ? zoomFactor : 1.0f)));
        float partHeight = effectiveTileSize * ratioY / this.pdfView.getZoom();
        float partWidth = effectiveTileSize * ratioX / this.pdfView.getZoom();
        int calculatedRows = partHeight > 0.0f && !Float.isNaN(partHeight) ? RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)((float)Math.ceil(1.0f / partHeight))), (int)1) : 1;
        int calculatedCols = partWidth > 0.0f && !Float.isNaN(partWidth) ? RangesKt.coerceAtLeast((int)MathKt.roundToInt((float)((float)Math.ceil(1.0f / partWidth))), (int)1) : 1;
        grid.setRows(calculatedRows);
        grid.setCols(calculatedCols);
    }

    private final void calculatePartSize(GridSize grid) {
        int validCols = RangesKt.coerceAtLeast((int)grid.getCols(), (int)1);
        int validRows = RangesKt.coerceAtLeast((int)grid.getRows(), (int)1);
        this.pageRelativePartWidth = 1.0f / (float)validCols;
        this.pageRelativePartHeight = 1.0f / (float)validRows;
        float zoomFactor = RangesKt.coerceAtLeast((float)this.pdfView.getZoom(), (float)1.0f);
        float effectiveTileSize = this.pdfView.getPdfViewerConfiguration().getRenderTileSize() * (zoomFactor >= 3.0f ? zoomFactor * 1.5f : (zoomFactor >= 2.0f ? zoomFactor * 1.25f : (zoomFactor > 1.0f ? zoomFactor : 1.0f)));
        Float f = Float.valueOf(this.pageRelativePartWidth);
        float it = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = it > 0.0f ? f : null;
        float safePageRelativePartWidth = f2 != null ? f2.floatValue() : 1.0f;
        Float f3 = Float.valueOf(this.pageRelativePartHeight);
        float it2 = ((Number)f3).floatValue();
        boolean bl2 = false;
        Float f4 = it2 > 0.0f ? f3 : null;
        float safePageRelativePartHeight = f4 != null ? f4.floatValue() : 1.0f;
        this.partRenderWidth = effectiveTileSize / safePageRelativePartWidth;
        this.partRenderHeight = effectiveTileSize / safePageRelativePartHeight;
        if (Float.isNaN(this.partRenderWidth) || Float.isNaN(this.partRenderHeight) || this.partRenderWidth <= 0.0f || this.partRenderHeight <= 0.0f) {
            this.partRenderWidth = this.pdfView.getPdfViewerConfiguration().getRenderTileSize();
            this.partRenderHeight = this.pdfView.getPdfViewerConfiguration().getRenderTileSize();
        }
    }

    private final List<RenderRange> getRenderRangeList(float firstXOffset, float firstYOffset, float lastXOffset, float lastYOffset) {
        List list;
        try {
            if (Float.isNaN(firstXOffset) || Float.isNaN(firstYOffset) || Float.isNaN(lastXOffset) || Float.isNaN(lastYOffset)) {
                throw new IllegalArgumentException("Offsets cannot be NaN");
            }
            float fixedFirstXOffset = -RangesKt.coerceAtMost((float)firstXOffset, (float)0.0f);
            float fixedFirstYOffset = -RangesKt.coerceAtMost((float)firstYOffset, (float)0.0f);
            float fixedLastXOffset = -RangesKt.coerceAtMost((float)lastXOffset, (float)0.0f);
            float fixedLastYOffset = -RangesKt.coerceAtMost((float)lastYOffset, (float)0.0f);
            float offsetFirst = this.pdfView.isSwipeVertical$pdfpreview_release() ? fixedFirstYOffset : fixedFirstXOffset;
            float offsetLast = this.pdfView.isSwipeVertical$pdfpreview_release() ? fixedLastYOffset : fixedLastXOffset;
            int firstPage = RangesKt.coerceAtLeast((int)this.pdfView.getPdfFile().getPageAtOffset(offsetFirst, this.pdfView.getZoom()), (int)0);
            int lastPage = RangesKt.coerceAtMost((int)this.pdfView.getPdfFile().getPageAtOffset(offsetLast, this.pdfView.getZoom()), (int)(this.pdfView.getPdfFile().getPagesCount() - 1));
            int pageCount = lastPage - firstPage + 1;
            List renderRanges = new LinkedList();
            int page = firstPage;
            if (page <= lastPage) {
                while (true) {
                    RenderRange range = new RenderRange(0, null, null, null, 15, null);
                    range.setPage(page);
                    float pageFirstXOffset = 0.0f;
                    float pageFirstYOffset = 0.0f;
                    float pageLastXOffset = 0.0f;
                    float pageLastYOffset = 0.0f;
                    int n = page;
                    if (n == firstPage) {
                        pageFirstXOffset = fixedFirstXOffset;
                        pageFirstYOffset = fixedFirstYOffset;
                        if (pageCount == 1) {
                            pageLastXOffset = fixedLastXOffset;
                            pageLastYOffset = fixedLastYOffset;
                        } else {
                            float pageOffset = this.pdfView.getPdfFile().getPageOffset(page, this.pdfView.getZoom());
                            SizeF pageSize = this.pdfView.getPdfFile().getScaledPageSize(page, this.pdfView.getZoom());
                            if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
                                pageLastXOffset = fixedLastXOffset;
                                pageLastYOffset = pageOffset + pageSize.getHeight();
                            } else {
                                pageLastYOffset = fixedLastYOffset;
                                pageLastXOffset = pageOffset + pageSize.getWidth();
                            }
                        }
                    } else if (n == lastPage) {
                        pageOffset = this.pdfView.getPdfFile().getPageOffset(page, this.pdfView.getZoom());
                        if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
                            pageFirstXOffset = fixedFirstXOffset;
                            pageFirstYOffset = pageOffset;
                        } else {
                            pageFirstYOffset = fixedFirstYOffset;
                            pageFirstXOffset = pageOffset;
                        }
                        pageLastXOffset = fixedLastXOffset;
                        pageLastYOffset = fixedLastYOffset;
                    } else {
                        pageOffset = this.pdfView.getPdfFile().getPageOffset(page, this.pdfView.getZoom());
                        SizeF pageSize = this.pdfView.getPdfFile().getScaledPageSize(page, this.pdfView.getZoom());
                        if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
                            pageFirstXOffset = fixedFirstXOffset;
                            pageFirstYOffset = pageOffset;
                            pageLastXOffset = fixedLastXOffset;
                            pageLastYOffset = pageOffset + pageSize.getHeight();
                        } else {
                            pageFirstXOffset = pageOffset;
                            pageFirstYOffset = fixedFirstYOffset;
                            pageLastXOffset = pageOffset + pageSize.getWidth();
                            pageLastYOffset = fixedLastYOffset;
                        }
                    }
                    this.getPageColsRows(range.getGridSize(), range.getPage());
                    SizeF scaledPageSize = this.pdfView.getPdfFile().getScaledPageSize(range.getPage(), this.pdfView.getZoom());
                    float rowHeight = scaledPageSize.getHeight() / (float)range.getGridSize().getRows();
                    float colWidth = scaledPageSize.getWidth() / (float)range.getGridSize().getCols();
                    float secondaryOffset = this.pdfView.getPdfFile().getSecondaryPageOffset(page, this.pdfView.getZoom());
                    if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
                        range.getLeftTop().setRow((int)Math.floor(Math.abs(pageFirstYOffset - this.pdfView.getPdfFile().getPageOffset(range.getPage(), this.pdfView.getZoom())) / rowHeight));
                        range.getLeftTop().setCol((int)Math.floor(Math.abs(pageFirstXOffset - secondaryOffset) / colWidth));
                        range.getRightBottom().setRow((int)Math.floor(Math.abs(pageLastYOffset - this.pdfView.getPdfFile().getPageOffset(range.getPage(), this.pdfView.getZoom())) / rowHeight));
                        range.getRightBottom().setCol((int)Math.floor(Math.abs(pageLastXOffset - secondaryOffset) / colWidth));
                    } else {
                        range.getLeftTop().setRow((int)Math.floor(Math.abs(pageFirstYOffset - secondaryOffset) / rowHeight));
                        range.getLeftTop().setCol((int)Math.floor(Math.abs(pageFirstXOffset - this.pdfView.getPdfFile().getPageOffset(range.getPage(), this.pdfView.getZoom())) / colWidth));
                        range.getRightBottom().setRow((int)Math.floor(Math.abs(pageLastYOffset - secondaryOffset) / rowHeight));
                        range.getRightBottom().setCol((int)Math.floor(Math.abs(pageLastXOffset - this.pdfView.getPdfFile().getPageOffset(range.getPage(), this.pdfView.getZoom())) / colWidth));
                    }
                    renderRanges.add(range);
                    if (page == lastPage) break;
                    ++page;
                }
            }
            list = renderRanges;
        }
        catch (Exception e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = new Throwable(e.getMessage());
            }
            this.pdfView.onPageError$pdfpreview_release(new PageRenderingException(-1, throwable));
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void loadVisible() {
        LogWriter logWriter = this.pdfView.getLogWriter();
        if (logWriter != null) {
            logWriter.writeLog("Loading visible pages", TAG);
        }
        if (this.pdfView.getPageCount() <= 0) {
            LogWriter logWriter2 = this.pdfView.getLogWriter();
            if (logWriter2 == null) return;
            logWriter2.writeLog("No pages available, skipping load", TAG);
            return;
        }
        if (this.pdfView.getSinglePageMode()) {
            block13: {
                try {
                    this.loadThumbnail(this.pdfView.getCurrentPage());
                }
                catch (Exception e) {
                    LogWriter logWriter3 = this.pdfView.getLogWriter();
                    if (logWriter3 == null) break block13;
                    logWriter3.writeLog("Failed to load thumbnail for current page " + this.pdfView.getCurrentPage() + ": " + e.getMessage(), TAG);
                }
            }
            try {
                GridSize gridSize = new GridSize(0, 0);
                this.getPageColsRows(gridSize, this.pdfView.getCurrentPage());
                this.calculatePartSize(gridSize);
                int partsToLoad = this.pdfView.getPdfViewerConfiguration().getMaxCachedBitmaps();
                this.loadPage(this.pdfView.getCurrentPage(), 0, gridSize.getRows() - 1, 0, gridSize.getCols() - 1, partsToLoad);
                return;
            }
            catch (Exception e) {
                LogWriter logWriter4 = this.pdfView.getLogWriter();
                if (logWriter4 == null) return;
                logWriter4.writeLog("Failed to load current page " + this.pdfView.getCurrentPage() + ": " + e.getMessage(), TAG);
                return;
            }
        }
        float scaledPreloadOffset = this.preloadOffset;
        List<RenderRange> rangeList = this.getRenderRangeList(-this.xOffset + scaledPreloadOffset, -this.yOffset + scaledPreloadOffset, -this.xOffset - (float)this.pdfView.getWidth() - scaledPreloadOffset, -this.yOffset - (float)this.pdfView.getHeight() - scaledPreloadOffset);
        int maxRangesToProcess = 3;
        List limitedRangeList = CollectionsKt.take((Iterable)rangeList, (int)maxRangesToProcess);
        for (RenderRange range : limitedRangeList) {
            try {
                this.loadThumbnail(range.getPage());
            }
            catch (Exception e) {
                LogWriter logWriter5 = this.pdfView.getLogWriter();
                if (logWriter5 == null) continue;
                logWriter5.writeLog("Failed to load thumbnail for page " + range.getPage() + ": " + e.getMessage(), TAG);
            }
        }
        int loadedParts = 0;
        int maxPartsPerCall = 40;
        for (RenderRange range : limitedRangeList) {
            try {
                this.calculatePartSize(range.getGridSize());
                int partsToLoad = Math.min(this.pdfView.getPdfViewerConfiguration().getMaxCachedBitmaps() - loadedParts, maxPartsPerCall - loadedParts);
                if (partsToLoad <= 0) return;
                if ((loadedParts += this.loadPage(range.getPage(), range.getLeftTop().getRow(), range.getRightBottom().getRow(), range.getLeftTop().getCol(), range.getRightBottom().getCol(), partsToLoad)) < maxPartsPerCall) continue;
                LogWriter logWriter6 = this.pdfView.getLogWriter();
                if (logWriter6 == null) return;
                logWriter6.writeLog("Reached max parts limit (" + maxPartsPerCall + "), deferring remaining load", TAG);
                return;
            }
            catch (Exception e) {
                LogWriter logWriter7 = this.pdfView.getLogWriter();
                if (logWriter7 == null) continue;
                logWriter7.writeLog("Failed to load page " + range.getPage() + ": " + e.getMessage(), TAG);
            }
        }
    }

    private final int loadPage(int page, int firstRow, int lastRow, int firstCol, int lastCol, int nbOfPartsLoadable) {
        float screenCenterRow = (float)(firstRow + lastRow) / 2.0f;
        float screenCenterCol = (float)(firstCol + lastCol) / 2.0f;
        List cellsWithDistance = new ArrayList();
        int row = firstRow;
        if (row <= lastRow) {
            while (true) {
                int col;
                if ((col = firstCol) <= lastCol) {
                    while (true) {
                        float distance = (float)Math.sqrt((float)Math.pow((float)row - screenCenterRow, 2) + (float)Math.pow((float)col - screenCenterCol, 2));
                        cellsWithDistance.add(new Triple((Object)row, (Object)col, (Object)Float.valueOf(distance)));
                        if (col == lastCol) break;
                        ++col;
                    }
                }
                if (row == lastRow) break;
                ++row;
            }
        }
        List $this$sortBy$iv = cellsWithDistance;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Triple it = (Triple)a;
                    boolean bl = false;
                    Comparable comparable = (Float)it.getThird();
                    it = (Triple)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Float)it.getThird()));
                }
            });
        }
        int loaded = 0;
        for (Triple triple : cellsWithDistance) {
            int col;
            int row2 = ((Number)triple.component1()).intValue();
            if (this.loadCell(page, row2, col = ((Number)triple.component2()).intValue(), this.pageRelativePartWidth, this.pageRelativePartHeight)) {
                ++loaded;
            }
            if (loaded < nbOfPartsLoadable) continue;
            return loaded;
        }
        return loaded;
    }

    private final boolean loadCell(int page, int row, int col, float pageRelativePartWidth, float pageRelativePartHeight) {
        float relX = pageRelativePartWidth * (float)col;
        float relY = pageRelativePartHeight * (float)row;
        float relWidth = relX + pageRelativePartWidth > 1.0f ? 1.0f - relX : pageRelativePartWidth;
        float relHeight = relY + pageRelativePartHeight > 1.0f ? 1.0f - relY : pageRelativePartHeight;
        float renderWidth = this.partRenderWidth * relWidth;
        float renderHeight = this.partRenderHeight * relHeight;
        if (renderWidth <= 0.0f || renderHeight <= 0.0f) {
            return false;
        }
        RectF pageRelativeBounds = new RectF(relX, relY, relX + relWidth, relY + relHeight);
        if (!this.pdfView.getCacheManager$pdfpreview_release().upPartIfContained(page, pageRelativeBounds, this.cacheOrder)) {
            RenderingHandler renderingHandler = this.pdfView.getRenderingHandler$pdfpreview_release();
            if (renderingHandler != null) {
                renderingHandler.addRenderingTask(page, renderWidth, renderHeight, pageRelativeBounds, false, this.cacheOrder, this.pdfView.isBestQuality$pdfpreview_release(), this.pdfView.isAnnotationRendering$pdfpreview_release());
            }
        }
        int n = this.cacheOrder;
        this.cacheOrder = n + 1;
        return true;
    }

    private final void loadThumbnail(int page) {
        block8: {
            if (page < 0 || page >= this.pdfView.getPageCount()) {
                LogWriter logWriter = this.pdfView.getLogWriter();
                if (logWriter != null) {
                    logWriter.writeLog("Invalid page index for thumbnail: " + page, TAG);
                }
                return;
            }
            SizeF sizeF = this.pdfView.getPdfFile().getPageSize(page);
            if (sizeF == null) {
                return;
            }
            SizeF pageSize = sizeF;
            if (pageSize.getWidth() <= 0.0f || pageSize.getHeight() <= 0.0f) {
                LogWriter logWriter = this.pdfView.getLogWriter();
                if (logWriter != null) {
                    logWriter.writeLog("Invalid page size for thumbnail page " + page + ": width=" + pageSize.getWidth() + ", height=" + pageSize.getHeight(), TAG);
                }
                return;
            }
            float thumbWidth = pageSize.getWidth() * this.pdfView.getPdfViewerConfiguration().getThumbnailQuality();
            float thumbHeight = pageSize.getHeight() * this.pdfView.getPdfViewerConfiguration().getThumbnailQuality();
            if (thumbWidth <= 0.0f || thumbHeight <= 0.0f || Float.isNaN(thumbWidth) || Float.isNaN(thumbHeight)) {
                LogWriter logWriter = this.pdfView.getLogWriter();
                if (logWriter != null) {
                    logWriter.writeLog("Invalid thumbnail dimensions for page " + page + ": width=" + thumbWidth + ", height=" + thumbHeight, TAG);
                }
                return;
            }
            if (this.pdfView.getCacheManager$pdfpreview_release().containsThumbnail(page, this.thumbnailRect)) break block8;
            RenderingHandler renderingHandler = this.pdfView.getRenderingHandler$pdfpreview_release();
            if (renderingHandler != null) {
                renderingHandler.addRenderingTask(page, thumbWidth, thumbHeight, this.thumbnailRect, true, 0, this.pdfView.isBestQuality$pdfpreview_release(), this.pdfView.isAnnotationRendering$pdfpreview_release());
            }
        }
    }

    public final void loadPages() {
        this.cacheOrder = 1;
        this.xOffset = -RangesKt.coerceIn((float)this.pdfView.getCurrentXOffset(), (float)-3.4028235E38f, (float)0.0f);
        this.yOffset = -RangesKt.coerceIn((float)this.pdfView.getCurrentYOffset(), (float)-3.4028235E38f, (float)0.0f);
        this.loadVisible();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/harissk/pdfpreview/PagesLoader$Companion;", "", "()V", "TAG", "", "pdfpreview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/harissk/pdfpreview/PagesLoader$GridSize;", "", "rows", "", "cols", "(II)V", "getCols", "()I", "setCols", "(I)V", "getRows", "setRows", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "pdfpreview_release"})
    private static final class GridSize {
        private int rows;
        private int cols;

        public GridSize(int rows, int cols) {
            this.rows = rows;
            this.cols = cols;
        }

        public /* synthetic */ GridSize(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getRows() {
            return this.rows;
        }

        public final void setRows(int n) {
            this.rows = n;
        }

        public final int getCols() {
            return this.cols;
        }

        public final void setCols(int n) {
            this.cols = n;
        }

        public final int component1() {
            return this.rows;
        }

        public final int component2() {
            return this.cols;
        }

        @NotNull
        public final GridSize copy(int rows, int cols) {
            return new GridSize(rows, cols);
        }

        public static /* synthetic */ GridSize copy$default(GridSize gridSize, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gridSize.rows;
            }
            if ((n3 & 2) != 0) {
                n2 = gridSize.cols;
            }
            return gridSize.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GridSize(rows=" + this.rows + ", cols=" + this.cols + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.rows);
            result = result * 31 + Integer.hashCode(this.cols);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GridSize)) {
                return false;
            }
            GridSize gridSize = (GridSize)other;
            if (this.rows != gridSize.rows) {
                return false;
            }
            return this.cols == gridSize.cols;
        }

        public GridSize() {
            this(0, 0, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/harissk/pdfpreview/PagesLoader$Holder;", "", "row", "", "col", "(II)V", "getCol", "()I", "setCol", "(I)V", "getRow", "setRow", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "pdfpreview_release"})
    private static final class Holder {
        private int row;
        private int col;

        public Holder(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public /* synthetic */ Holder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getRow() {
            return this.row;
        }

        public final void setRow(int n) {
            this.row = n;
        }

        public final int getCol() {
            return this.col;
        }

        public final void setCol(int n) {
            this.col = n;
        }

        public final int component1() {
            return this.row;
        }

        public final int component2() {
            return this.col;
        }

        @NotNull
        public final Holder copy(int row, int col) {
            return new Holder(row, col);
        }

        public static /* synthetic */ Holder copy$default(Holder holder, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = holder.row;
            }
            if ((n3 & 2) != 0) {
                n2 = holder.col;
            }
            return holder.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Holder(row=" + this.row + ", col=" + this.col + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.row);
            result = result * 31 + Integer.hashCode(this.col);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Holder)) {
                return false;
            }
            Holder holder = (Holder)other;
            if (this.row != holder.row) {
                return false;
            }
            return this.col == holder.col;
        }

        public Holder() {
            this(0, 0, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/harissk/pdfpreview/PagesLoader$RenderRange;", "", "page", "", "gridSize", "Lcom/harissk/pdfpreview/PagesLoader$GridSize;", "leftTop", "Lcom/harissk/pdfpreview/PagesLoader$Holder;", "rightBottom", "(ILcom/harissk/pdfpreview/PagesLoader$GridSize;Lcom/harissk/pdfpreview/PagesLoader$Holder;Lcom/harissk/pdfpreview/PagesLoader$Holder;)V", "getGridSize", "()Lcom/harissk/pdfpreview/PagesLoader$GridSize;", "setGridSize", "(Lcom/harissk/pdfpreview/PagesLoader$GridSize;)V", "getLeftTop", "()Lcom/harissk/pdfpreview/PagesLoader$Holder;", "setLeftTop", "(Lcom/harissk/pdfpreview/PagesLoader$Holder;)V", "getPage", "()I", "setPage", "(I)V", "getRightBottom", "setRightBottom", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "pdfpreview_release"})
    private static final class RenderRange {
        private int page;
        @NotNull
        private GridSize gridSize;
        @NotNull
        private Holder leftTop;
        @NotNull
        private Holder rightBottom;

        public RenderRange(int page, @NotNull GridSize gridSize, @NotNull Holder leftTop, @NotNull Holder rightBottom) {
            Intrinsics.checkNotNullParameter((Object)gridSize, (String)"gridSize");
            Intrinsics.checkNotNullParameter((Object)leftTop, (String)"leftTop");
            Intrinsics.checkNotNullParameter((Object)rightBottom, (String)"rightBottom");
            this.page = page;
            this.gridSize = gridSize;
            this.leftTop = leftTop;
            this.rightBottom = rightBottom;
        }

        public /* synthetic */ RenderRange(int n, GridSize gridSize, Holder holder, Holder holder2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                gridSize = new GridSize(0, 0, 3, null);
            }
            if ((n2 & 4) != 0) {
                holder = new Holder(0, 0, 3, null);
            }
            if ((n2 & 8) != 0) {
                holder2 = new Holder(0, 0, 3, null);
            }
            this(n, gridSize, holder, holder2);
        }

        public final int getPage() {
            return this.page;
        }

        public final void setPage(int n) {
            this.page = n;
        }

        @NotNull
        public final GridSize getGridSize() {
            return this.gridSize;
        }

        public final void setGridSize(@NotNull GridSize gridSize) {
            Intrinsics.checkNotNullParameter((Object)gridSize, (String)"<set-?>");
            this.gridSize = gridSize;
        }

        @NotNull
        public final Holder getLeftTop() {
            return this.leftTop;
        }

        public final void setLeftTop(@NotNull Holder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"<set-?>");
            this.leftTop = holder;
        }

        @NotNull
        public final Holder getRightBottom() {
            return this.rightBottom;
        }

        public final void setRightBottom(@NotNull Holder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"<set-?>");
            this.rightBottom = holder;
        }

        public final int component1() {
            return this.page;
        }

        @NotNull
        public final GridSize component2() {
            return this.gridSize;
        }

        @NotNull
        public final Holder component3() {
            return this.leftTop;
        }

        @NotNull
        public final Holder component4() {
            return this.rightBottom;
        }

        @NotNull
        public final RenderRange copy(int page, @NotNull GridSize gridSize, @NotNull Holder leftTop, @NotNull Holder rightBottom) {
            Intrinsics.checkNotNullParameter((Object)gridSize, (String)"gridSize");
            Intrinsics.checkNotNullParameter((Object)leftTop, (String)"leftTop");
            Intrinsics.checkNotNullParameter((Object)rightBottom, (String)"rightBottom");
            return new RenderRange(page, gridSize, leftTop, rightBottom);
        }

        public static /* synthetic */ RenderRange copy$default(RenderRange renderRange, int n, GridSize gridSize, Holder holder, Holder holder2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = renderRange.page;
            }
            if ((n2 & 2) != 0) {
                gridSize = renderRange.gridSize;
            }
            if ((n2 & 4) != 0) {
                holder = renderRange.leftTop;
            }
            if ((n2 & 8) != 0) {
                holder2 = renderRange.rightBottom;
            }
            return renderRange.copy(n, gridSize, holder, holder2);
        }

        @NotNull
        public String toString() {
            return "RenderRange(page=" + this.page + ", gridSize=" + this.gridSize + ", leftTop=" + this.leftTop + ", rightBottom=" + this.rightBottom + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.page);
            result = result * 31 + this.gridSize.hashCode();
            result = result * 31 + this.leftTop.hashCode();
            result = result * 31 + this.rightBottom.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenderRange)) {
                return false;
            }
            RenderRange renderRange = (RenderRange)other;
            if (this.page != renderRange.page) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gridSize, (Object)renderRange.gridSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.leftTop, (Object)renderRange.leftTop)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rightBottom, (Object)renderRange.rightBottom);
        }

        public RenderRange() {
            this(0, null, null, null, 15, null);
        }
    }
}

