/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.decorators;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.VavrBulkhead;
import io.github.resilience4j.cache.Cache;
import io.github.resilience4j.cache.VavrCache;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.VavrCircuitBreaker;
import io.github.resilience4j.core.VavrCheckedFunctionUtils;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.VavrRateLimiter;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.VavrRetry;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedRunnable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public interface VavrDecorators {
    public static <T> DecorateCheckedSupplier<T> ofCheckedSupplier(CheckedFunction0<T> supplier) {
        return new DecorateCheckedSupplier<T>(supplier);
    }

    public static <T, R> DecorateCheckedFunction<T, R> ofCheckedFunction(CheckedFunction1<T, R> function) {
        return new DecorateCheckedFunction<T, R>(function);
    }

    public static DecorateCheckedRunnable ofCheckedRunnable(CheckedRunnable supplier) {
        return new DecorateCheckedRunnable(supplier);
    }

    public static class DecorateCheckedSupplier<T> {
        private CheckedFunction0<T> supplier;

        private DecorateCheckedSupplier(CheckedFunction0<T> supplier) {
            this.supplier = supplier;
        }

        public DecorateCheckedSupplier<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.supplier = VavrCircuitBreaker.decorateCheckedSupplier(circuitBreaker, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withRetry(Retry retryContext) {
            this.supplier = VavrRetry.decorateCheckedSupplier(retryContext, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCheckedSupplier<T> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.supplier = VavrRateLimiter.decorateCheckedSupplier(rateLimiter, permits, this.supplier);
            return this;
        }

        public <K> DecorateCheckedFunction<K, T> withCache(Cache<K, T> cache) {
            return VavrDecorators.ofCheckedFunction(VavrCache.decorateCheckedSupplier(cache, this.supplier));
        }

        public DecorateCheckedSupplier<T> withBulkhead(Bulkhead bulkhead) {
            this.supplier = VavrBulkhead.decorateCheckedSupplier(bulkhead, this.supplier);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(CheckedFunction2<T, Throwable, T> handler) {
            this.supplier = VavrCheckedFunctionUtils.andThen(this.supplier, handler);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(Predicate<T> resultPredicate, CheckedFunction1<T, T> resultHandler) {
            this.supplier = VavrCheckedFunctionUtils.recover(this.supplier, resultPredicate, resultHandler);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(List<Class<? extends Throwable>> exceptionTypes, CheckedFunction1<Throwable, T> exceptionHandler) {
            this.supplier = VavrCheckedFunctionUtils.recover(this.supplier, exceptionTypes, exceptionHandler);
            return this;
        }

        public DecorateCheckedSupplier<T> withFallback(CheckedFunction1<Throwable, T> exceptionHandler) {
            this.supplier = VavrCheckedFunctionUtils.recover(this.supplier, exceptionHandler);
            return this;
        }

        public <X extends Throwable> DecorateCheckedSupplier<T> withFallback(Class<X> exceptionType, CheckedFunction1<Throwable, T> exceptionHandler) {
            this.supplier = VavrCheckedFunctionUtils.recover(this.supplier, exceptionType, exceptionHandler);
            return this;
        }

        public CheckedFunction0<T> decorate() {
            return this.supplier;
        }

        public T get() throws Throwable {
            return (T)this.supplier.apply();
        }
    }

    public static class DecorateCheckedFunction<T, R> {
        private CheckedFunction1<T, R> function;

        private DecorateCheckedFunction(CheckedFunction1<T, R> function) {
            this.function = function;
        }

        public DecorateCheckedFunction<T, R> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.function = VavrCircuitBreaker.decorateCheckedFunction(circuitBreaker, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRetry(Retry retryContext) {
            this.function = VavrRetry.decorateCheckedFunction(retryContext, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter) {
            return this.withRateLimiter(rateLimiter, 1);
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.function = VavrRateLimiter.decorateCheckedFunction(rateLimiter, permits, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withRateLimiter(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator) {
            this.function = VavrRateLimiter.decorateCheckedFunction(rateLimiter, permitsCalculator, this.function);
            return this;
        }

        public DecorateCheckedFunction<T, R> withBulkhead(Bulkhead bulkhead) {
            this.function = VavrBulkhead.decorateCheckedFunction(bulkhead, this.function);
            return this;
        }

        public CheckedFunction1<T, R> decorate() {
            return this.function;
        }

        public R apply(T t) throws Throwable {
            return (R)this.function.apply(t);
        }
    }

    public static class DecorateCheckedRunnable {
        private CheckedRunnable runnable;

        private DecorateCheckedRunnable(CheckedRunnable runnable) {
            this.runnable = runnable;
        }

        public DecorateCheckedRunnable withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.runnable = VavrCircuitBreaker.decorateCheckedRunnable(circuitBreaker, this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRetry(Retry retryContext) {
            this.runnable = VavrRetry.decorateCheckedRunnable(retryContext, this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRateLimiter(RateLimiter rateLimiter) {
            this.runnable = VavrRateLimiter.decorateCheckedRunnable(rateLimiter, this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withRateLimiter(RateLimiter rateLimiter, int permits) {
            this.runnable = VavrRateLimiter.decorateCheckedRunnable(rateLimiter, permits, this.runnable);
            return this;
        }

        public DecorateCheckedRunnable withBulkhead(Bulkhead bulkhead) {
            this.runnable = VavrBulkhead.decorateCheckedRunnable(bulkhead, this.runnable);
            return this;
        }

        public CheckedRunnable decorate() {
            return this.runnable;
        }

        public void run() throws Throwable {
            this.runnable.run();
        }
    }
}

