/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.test;

import io.github.resilience4j.core.ContextPropagator;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.MDC;

public class TestContextPropagators {

    public static class TestThreadLocalContextPropagatorWithHolder<T>
    implements ContextPropagator<T> {
        public Supplier<Optional<T>> retrieve() {
            return () -> TestThreadLocalContextHolder.get();
        }

        public Consumer<Optional<T>> copy() {
            return t -> t.ifPresent(e -> {
                this.clear();
                TestThreadLocalContextHolder.put(e);
            });
        }

        public Consumer<Optional<T>> clear() {
            return t -> TestThreadLocalContextHolder.clear();
        }

        public static class TestThreadLocalContextHolder {
            private static final ThreadLocal<Object> threadLocal = new ThreadLocal();

            private TestThreadLocalContextHolder() {
            }

            public static void put(Object context) {
                if (threadLocal.get() != null) {
                    TestThreadLocalContextHolder.clear();
                }
                threadLocal.set(context);
            }

            public static Map<String, String> getMDCContext() {
                return Optional.ofNullable(MDC.getCopyOfContextMap()).orElse(Collections.emptyMap());
            }

            public static void clear() {
                if (threadLocal.get() != null) {
                    threadLocal.set(null);
                    threadLocal.remove();
                }
            }

            public static Optional<?> get() {
                return Optional.ofNullable(threadLocal.get());
            }
        }
    }

    public static class TestThreadLocalContextPropagator
    implements ContextPropagator<String> {
        private ThreadLocal<String> threadLocal;

        public TestThreadLocalContextPropagator(ThreadLocal<String> threadLocal) {
            this.threadLocal = threadLocal;
        }

        public Supplier<Optional<String>> retrieve() {
            return () -> Optional.ofNullable(this.threadLocal.get());
        }

        public Consumer<Optional<String>> copy() {
            return t -> t.ifPresent(e -> {
                if (this.threadLocal.get() != null) {
                    this.threadLocal.set(null);
                    this.threadLocal.remove();
                }
                this.threadLocal.set((String)e);
            });
        }

        public Consumer<Optional<String>> clear() {
            return t -> {
                if (this.threadLocal.get() != null) {
                    this.threadLocal.set(null);
                    this.threadLocal.remove();
                }
            };
        }
    }
}

