/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.utils;

import io.github.resilience4j.core.lang.Nullable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationExtractor.class);

    private AnnotationExtractor() {
    }

    @Nullable
    public static <T extends Annotation> T extract(Class<?> targetClass, Class<T> annotationClass) {
        T annotation = null;
        if (targetClass.isAnnotationPresent(annotationClass) && (annotation = (T)targetClass.getAnnotation(annotationClass)) == null && logger.isDebugEnabled()) {
            logger.debug("TargetClass has no annotation '{}'", (Object)annotationClass.getSimpleName());
            annotation = targetClass.getDeclaredAnnotation(annotationClass);
            if (annotation == null && logger.isDebugEnabled()) {
                logger.debug("TargetClass has no declared annotation '{}'", (Object)annotationClass.getSimpleName());
            }
        }
        return annotation;
    }

    @Nullable
    public static <T extends Annotation> T extractAnnotationFromProxy(Object targetProxy, Class<T> annotationClass) {
        if (targetProxy.getClass().getInterfaces().length == 1) {
            return AnnotationExtractor.extract(targetProxy.getClass().getInterfaces()[0], annotationClass);
        }
        if (targetProxy.getClass().getInterfaces().length > 1) {
            return AnnotationExtractor.extractAnnotationFromClosestMatch(targetProxy, annotationClass);
        }
        return null;
    }

    @Nullable
    private static <T extends Annotation> T extractAnnotationFromClosestMatch(Object targetProxy, Class<T> annotationClass) {
        int numberOfImplementations = targetProxy.getClass().getInterfaces().length;
        for (int depth = 0; depth < numberOfImplementations; ++depth) {
            T annotation = AnnotationExtractor.extract(targetProxy.getClass().getInterfaces()[depth], annotationClass);
            if (!Objects.nonNull(annotation)) continue;
            return annotation;
        }
        return null;
    }
}

