/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class IgnoreClassBindingExceptionConverter
implements Converter<String, Class<? extends Throwable>> {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreClassBindingExceptionConverter.class);
    private final boolean ignoreUnknownExceptions;

    public IgnoreClassBindingExceptionConverter(boolean ignoreUnknownExceptions) {
        this.ignoreUnknownExceptions = ignoreUnknownExceptions;
        if (ignoreUnknownExceptions) {
            LOG.debug("Configured to ignore unknown exceptions. Unknown exceptions will be replaced with a placeholder.");
        }
    }

    public Class<? extends Throwable> convert(String source) {
        try {
            return Class.forName(source);
        }
        catch (ClassNotFoundException ex) {
            if (this.ignoreUnknownExceptions) {
                LOG.debug("Exception class '{}' could not be found. Ignoring and substituting with placeholder exception.", (Object)source);
                return PlaceHolderException.class;
            }
            LOG.error("Class '{}' not found and ignoreClassBindingExceptions is set to false.", (Object)source);
            throw new IllegalArgumentException("Class not found: " + source, ex);
        }
    }

    public static class PlaceHolderException
    extends Throwable {
    }
}

