/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspect;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.circuitbreaker.configure.ReactorCircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.configure.RxJava2CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class CircuitBreakerConfiguration {
    private final CircuitBreakerConfigurationProperties circuitBreakerProperties;

    public CircuitBreakerConfiguration(CircuitBreakerConfigurationProperties circuitBreakerProperties) {
        this.circuitBreakerProperties = circuitBreakerProperties;
    }

    @Bean
    public CircuitBreakerRegistry circuitBreakerRegistry(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer) {
        CircuitBreakerRegistry circuitBreakerRegistry = this.createCircuitBreakerRegistry(this.circuitBreakerProperties, circuitBreakerRegistryEventConsumer);
        this.registerEventConsumer(circuitBreakerRegistry, eventConsumerRegistry);
        this.initCircuitBreakerRegistry(circuitBreakerRegistry);
        return circuitBreakerRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer(Optional<List<RegistryEventConsumer<CircuitBreaker>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    public CircuitBreakerAspect circuitBreakerAspect(CircuitBreakerRegistry circuitBreakerRegistry, @Autowired(required=false) List<CircuitBreakerAspectExt> circuitBreakerAspectExtList, FallbackDecorators fallbackDecorators) {
        return new CircuitBreakerAspect(this.circuitBreakerProperties, circuitBreakerRegistry, circuitBreakerAspectExtList, fallbackDecorators);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public RxJava2CircuitBreakerAspectExt rxJava2CircuitBreakerAspect() {
        return new RxJava2CircuitBreakerAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public ReactorCircuitBreakerAspectExt reactorCircuitBreakerAspect() {
        return new ReactorCircuitBreakerAspectExt();
    }

    @Bean
    public EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    public CircuitBreakerRegistry createCircuitBreakerRegistry(CircuitBreakerConfigurationProperties circuitBreakerProperties, RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer) {
        Map<String, CircuitBreakerConfig> configs = circuitBreakerProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> circuitBreakerProperties.createCircuitBreakerConfig((CircuitBreakerConfigurationProperties.InstanceProperties)entry.getValue())));
        return CircuitBreakerRegistry.of(configs, circuitBreakerRegistryEventConsumer);
    }

    public void initCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
        this.circuitBreakerProperties.getInstances().forEach((name, properties) -> circuitBreakerRegistry.circuitBreaker(name, this.circuitBreakerProperties.createCircuitBreakerConfig((CircuitBreakerConfigurationProperties.InstanceProperties)properties)));
    }

    public void registerEventConsumer(CircuitBreakerRegistry circuitBreakerRegistry, EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
        circuitBreakerRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (CircuitBreaker)event.getAddedEntry()));
    }

    private void registerEventConsumer(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, CircuitBreaker circuitBreaker) {
        int eventConsumerBufferSize = this.circuitBreakerProperties.findCircuitBreakerProperties(circuitBreaker.getName()).map(CircuitBreakerConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        circuitBreaker.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(circuitBreaker.getName(), eventConsumerBufferSize));
    }
}

