/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.common.ratelimiter.configuration.RateLimiterConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspect;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import io.github.resilience4j.ratelimiter.configure.ReactorRateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.configure.RxJava2RateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RateLimiterConfiguration {
    @Bean
    public RateLimiterRegistry rateLimiterRegistry(RateLimiterConfigurationProperties rateLimiterProperties, EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry) {
        RateLimiterRegistry rateLimiterRegistry = this.createRateLimiterRegistry(rateLimiterProperties);
        this.registerEventConsumer(rateLimiterRegistry, rateLimiterEventsConsumerRegistry, rateLimiterProperties);
        rateLimiterProperties.getInstances().forEach((name, properties) -> rateLimiterRegistry.rateLimiter(name, rateLimiterProperties.createRateLimiterConfig((RateLimiterConfigurationProperties.InstanceProperties)properties)));
        return rateLimiterRegistry;
    }

    private RateLimiterRegistry createRateLimiterRegistry(RateLimiterConfigurationProperties rateLimiterConfigurationProperties) {
        Map<String, RateLimiterConfig> configs = rateLimiterConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> rateLimiterConfigurationProperties.createRateLimiterConfig((RateLimiterConfigurationProperties.InstanceProperties)entry.getValue())));
        return RateLimiterRegistry.of(configs);
    }

    private void registerEventConsumer(RateLimiterRegistry rateLimiterRegistry, EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry, RateLimiterConfigurationProperties rateLimiterConfigurationProperties) {
        rateLimiterRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (RateLimiter)event.getAddedEntry(), rateLimiterConfigurationProperties));
    }

    private void registerEventConsumer(EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry, RateLimiter rateLimiter, RateLimiterConfigurationProperties rateLimiterConfigurationProperties) {
        RateLimiterConfigurationProperties.InstanceProperties limiterProperties = (RateLimiterConfigurationProperties.InstanceProperties)rateLimiterConfigurationProperties.getInstances().get(rateLimiter.getName());
        if (limiterProperties != null && limiterProperties.getSubscribeForEvents() != null && limiterProperties.getSubscribeForEvents().booleanValue()) {
            rateLimiter.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(rateLimiter.getName(), limiterProperties.getEventConsumerBufferSize() != null && limiterProperties.getEventConsumerBufferSize() != 0 ? limiterProperties.getEventConsumerBufferSize() : 100));
        }
    }

    @Bean
    public RateLimiterAspect rateLimiterAspect(RateLimiterConfigurationProperties rateLimiterProperties, RateLimiterRegistry rateLimiterRegistry, @Autowired(required=false) List<RateLimiterAspectExt> rateLimiterAspectExtList, FallbackDecorators fallbackDecorators) {
        return new RateLimiterAspect(rateLimiterRegistry, rateLimiterProperties, rateLimiterAspectExtList, fallbackDecorators);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class})
    public RxJava2RateLimiterAspectExt rxJava2RateLimterAspectExt() {
        return new RxJava2RateLimiterAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class})
    public ReactorRateLimiterAspectExt reactorRateLimiterAspectExt() {
        return new ReactorRateLimiterAspectExt();
    }

    @Bean
    public EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }
}

