/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.utils.AnnotationExtractor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

@Aspect
public class CircuitBreakerAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerAspect.class);
    private final CircuitBreakerConfigurationProperties circuitBreakerProperties;
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final List<CircuitBreakerAspectExt> circuitBreakerAspectExtList;

    public CircuitBreakerAspect(CircuitBreakerConfigurationProperties backendMonitorPropertiesRegistry, CircuitBreakerRegistry circuitBreakerRegistry, @Autowired(required=false) List<CircuitBreakerAspectExt> circuitBreakerAspectExtList) {
        this.circuitBreakerProperties = backendMonitorPropertiesRegistry;
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.circuitBreakerAspectExtList = circuitBreakerAspectExtList;
    }

    @Pointcut(value="@within(circuitBreaker) || @annotation(circuitBreaker)", argNames="circuitBreaker")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker circuitBreaker) {
    }

    @Around(value="matchAnnotatedClassOrMethod(backendMonitored)", argNames="proceedingJoinPoint, backendMonitored")
    public Object circuitBreakerAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker backendMonitored) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (backendMonitored == null) {
            backendMonitored = this.getBackendMonitoredAnnotation(proceedingJoinPoint);
        }
        if (backendMonitored == null) {
            return proceedingJoinPoint.proceed();
        }
        String backend = backendMonitored.name();
        CircuitBreaker circuitBreaker = this.getOrCreateCircuitBreaker(methodName, backend);
        Class<?> returnType = method.getReturnType();
        if (this.circuitBreakerAspectExtList != null && !this.circuitBreakerAspectExtList.isEmpty()) {
            for (CircuitBreakerAspectExt circuitBreakerAspectExt : this.circuitBreakerAspectExtList) {
                if (!circuitBreakerAspectExt.canHandleReturnType(returnType)) continue;
                return circuitBreakerAspectExt.handle(proceedingJoinPoint, circuitBreaker, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, circuitBreaker);
        }
        return this.defaultHandling(proceedingJoinPoint, circuitBreaker, methodName);
    }

    private CircuitBreaker getOrCreateCircuitBreaker(String methodName, String backend) {
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(backend, () -> this.circuitBreakerProperties.createCircuitBreakerConfig(backend));
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved circuit breaker '{}' with failure rate '{}' and wait interval'{}' for method: '{}'", new Object[]{backend, Float.valueOf(circuitBreaker.getCircuitBreakerConfig().getFailureRateThreshold()), circuitBreaker.getCircuitBreakerConfig().getWaitDurationInOpenState(), methodName});
        }
        return circuitBreaker;
    }

    @Nullable
    private io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker getBackendMonitoredAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("circuitBreaker parameter is null");
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class);
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker) throws Throwable {
        CompletableFuture promise = new CompletableFuture();
        long start = System.nanoTime();
        if (!circuitBreaker.isCallPermitted()) {
            promise.completeExceptionally((Throwable)new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", circuitBreaker.getName())));
        } else {
            CompletionStage result = (CompletionStage)proceedingJoinPoint.proceed();
            if (result != null) {
                result.whenComplete((v, t) -> {
                    long durationInNanos = System.nanoTime() - start;
                    if (t != null) {
                        circuitBreaker.onError(durationInNanos, t);
                        promise.completeExceptionally((Throwable)t);
                    } else {
                        circuitBreaker.onSuccess(durationInNanos);
                        promise.complete(v);
                    }
                });
            }
        }
        return promise;
    }

    private Object defaultHandling(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker, String methodName) throws Throwable {
        return circuitBreaker.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    public int getOrder() {
        return this.circuitBreakerProperties.getCircuitBreakerAspectOrder();
    }
}

