/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspect;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.utils.AspectUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableOperator;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableOperator;
import io.reactivex.Maybe;
import io.reactivex.MaybeOperator;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableOperator;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleOperator;
import io.reactivex.SingleSource;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxJava2CircuitBreakerAspectExt
implements CircuitBreakerAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerAspect.class);
    private final Set<Class> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker, String methodName) throws Throwable {
        CircuitBreakerOperator circuitBreakerOperator = CircuitBreakerOperator.of((CircuitBreaker)circuitBreaker);
        Object returnValue = proceedingJoinPoint.proceed();
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.lift((ObservableOperator)circuitBreakerOperator);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.lift((SingleOperator)circuitBreakerOperator);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.lift((CompletableOperator)circuitBreakerOperator);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.lift((MaybeOperator)circuitBreakerOperator);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.lift((FlowableOperator)circuitBreakerOperator);
        }
        logger.error("Unsupported type for RxJava2 circuit breaker return type {} for method {}", (Object)returnValue.getClass().getTypeName(), (Object)methodName);
        throw new IllegalArgumentException("Not Supported type for the circuit breaker in RxJava2:" + returnValue.getClass().getName());
    }
}

