/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspect;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.internal.InMemoryRateLimiterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RateLimiterConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterConfiguration.class);

    @Bean
    public RateLimiterRegistry rateLimiterRegistry(RateLimiterConfigurationProperties rateLimiterProperties, EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry, ConfigurableBeanFactory beanFactory) {
        InMemoryRateLimiterRegistry rateLimiterRegistry = new InMemoryRateLimiterRegistry(RateLimiterConfig.ofDefaults());
        rateLimiterProperties.getLimiters().forEach((arg_0, arg_1) -> this.lambda$rateLimiterRegistry$0((RateLimiterRegistry)rateLimiterRegistry, rateLimiterEventsConsumerRegistry, arg_0, arg_1));
        return rateLimiterRegistry;
    }

    @Bean
    public RateLimiterAspect rateLimiterAspect(RateLimiterConfigurationProperties rateLimiterProperties, RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterAspect(rateLimiterRegistry, rateLimiterProperties);
    }

    @Bean
    public EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private void subscribeToLimiterEvents(EventConsumerRegistry<RateLimiterEvent> rateLimiterEventsConsumerRegistry, String name, RateLimiterConfigurationProperties.LimiterProperties properties, RateLimiter rateLimiter) {
        CircularEventConsumer eventConsumer = rateLimiterEventsConsumerRegistry.createEventConsumer(name, properties.getEventConsumerBufferSize().intValue());
        rateLimiter.getEventPublisher().onEvent((EventConsumer)eventConsumer);
        logger.debug("Autoconfigure subscription for Rate Limiter {}", (Object)rateLimiter);
    }

    private RateLimiter createRateLimiter(RateLimiterRegistry rateLimiterRegistry, String name, RateLimiterConfigurationProperties.LimiterProperties properties) {
        RateLimiter rateLimiter = rateLimiterRegistry.rateLimiter(name, RateLimiterConfigurationProperties.createRateLimiterConfig(properties));
        logger.debug("Autoconfigure Rate Limiter registered. {}", (Object)rateLimiter);
        return rateLimiter;
    }

    private /* synthetic */ void lambda$rateLimiterRegistry$0(RateLimiterRegistry rateLimiterRegistry, EventConsumerRegistry rateLimiterEventsConsumerRegistry, String name, RateLimiterConfigurationProperties.LimiterProperties properties) {
        RateLimiter rateLimiter = this.createRateLimiter(rateLimiterRegistry, name, properties);
        if (properties.getSubscribeForEvents().booleanValue()) {
            this.subscribeToLimiterEvents((EventConsumerRegistry<RateLimiterEvent>)rateLimiterEventsConsumerRegistry, name, properties, rateLimiter);
        }
    }
}

