/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEndpointResponse;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="retries")
public class RetryEndpoint {
    private final RetryRegistry retryRegistry;

    public RetryEndpoint(RetryRegistry retryRegistry) {
        this.retryRegistry = retryRegistry;
    }

    @ReadOperation
    public RetryEndpointResponse getAllRetries() {
        List retries = this.retryRegistry.getAllRetries().stream().map(Retry::getName).sorted().collect(Collectors.toList());
        return new RetryEndpointResponse(retries);
    }
}

