/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.autoconfigure.CircuitBreakerConfigurationOnMissingBean;
import io.github.resilience4j.circuitbreaker.autoconfigure.CircuitBreakerProperties;
import io.github.resilience4j.circuitbreaker.configure.IgnoreClassBindingExceptionConverter;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.monitoring.endpoint.CircuitBreakerEndpoint;
import io.github.resilience4j.circuitbreaker.monitoring.endpoint.CircuitBreakerEventsEndpoint;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.fallback.autoconfigure.FallbackConfigurationOnMissingBean;
import java.util.Arrays;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;

@Configuration
@ConditionalOnClass(value={CircuitBreaker.class})
@EnableConfigurationProperties(value={CircuitBreakerProperties.class})
@Import(value={CircuitBreakerConfigurationOnMissingBean.class, FallbackConfigurationOnMissingBean.class})
public class CircuitBreakerAutoConfiguration {
    private final AbstractEnvironment environment;

    public CircuitBreakerAutoConfiguration(AbstractEnvironment environment) {
        this.environment = environment;
    }

    @Bean
    @ConfigurationPropertiesBinding
    public IgnoreClassBindingExceptionConverter ignoreClassBindingExceptionsConverter() {
        boolean ignoreClassBindingExceptions = this.isIgnoreClassBindingExceptionsEnabled();
        return new IgnoreClassBindingExceptionConverter(ignoreClassBindingExceptions);
    }

    @Bean
    public GenericConversionService genericConversionService() {
        GenericConversionService genericConversionService = new GenericConversionService();
        genericConversionService.addConverter((Converter)this.ignoreClassBindingExceptionsConverter());
        return genericConversionService;
    }

    private boolean isIgnoreClassBindingExceptionsEnabled() {
        return this.environment.getPropertySources().stream().filter(EnumerablePropertySource.class::isInstance).map(EnumerablePropertySource.class::cast).flatMap(ps -> Arrays.stream(ps.getPropertyNames())).filter(name -> name.contains(".configs.") && name.endsWith(".ignoreClassBindingExceptions") || name.contains(".configs.") && name.endsWith(".ignore-class-binding-exceptions")).findFirst().map(name -> (Boolean)this.environment.getProperty(name, Boolean.class, (Object)false)).orElse(false);
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    static class CircuitBreakerEndpointAutoConfiguration {
        CircuitBreakerEndpointAutoConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public CircuitBreakerEndpoint circuitBreakerEndpoint(CircuitBreakerRegistry circuitBreakerRegistry) {
            return new CircuitBreakerEndpoint(circuitBreakerRegistry);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public CircuitBreakerEventsEndpoint circuitBreakerEventsEndpoint(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
            return new CircuitBreakerEventsEndpoint(eventConsumerRegistry);
        }
    }
}

