/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.autoconfigure;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetricsPublisher;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MeterRegistry.class, Bulkhead.class, TaggedBulkheadMetricsPublisher.class})
@AutoConfigureAfter(name={"org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration"})
@ConditionalOnProperty(value={"resilience4j.bulkhead.metrics.enabled"}, matchIfMissing=true)
public class BulkheadMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.bulkhead.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TaggedBulkheadMetrics registerBulkheadMetrics(BulkheadRegistry bulkheadRegistry) {
        return TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry);
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(value={"resilience4j.bulkhead.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TaggedBulkheadMetricsPublisher taggedBulkheadMetricsPublisher(MeterRegistry meterRegistry) {
        return new TaggedBulkheadMetricsPublisher(meterRegistry);
    }
}

