/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.autoconfigure;

import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetricsPublisher;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MeterRegistry.class, RateLimiter.class, TaggedRateLimiterMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.enabled"}, matchIfMissing=true)
public class RateLimiterMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TaggedRateLimiterMetrics registerRateLimiterMetrics(RateLimiterRegistry rateLimiterRegistry) {
        return TaggedRateLimiterMetrics.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry);
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TaggedRateLimiterMetricsPublisher taggedRateLimiterMetricsPublisher(MeterRegistry meterRegistry) {
        return new TaggedRateLimiterMetricsPublisher(meterRegistry);
    }
}

