/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.github.resilience4j.retry.monitoring.endpoint.RetryEventDTO;
import io.github.resilience4j.retry.monitoring.endpoint.RetryEventDTOBuilder;

class RetryEventDTOFactory {
    private RetryEventDTOFactory() {
    }

    static RetryEventDTO createRetryEventDTO(RetryEvent event) {
        switch (event.getEventType()) {
            case ERROR: {
                RetryOnErrorEvent onErrorEvent = (RetryOnErrorEvent)event;
                return RetryEventDTOFactory.newRetryEventDTOBuilder((RetryEvent)onErrorEvent).throwable(onErrorEvent.getLastThrowable()).numberOfAttempts(onErrorEvent.getNumberOfRetryAttempts()).build();
            }
            case SUCCESS: {
                RetryOnSuccessEvent onSuccessEvent = (RetryOnSuccessEvent)event;
                return RetryEventDTOFactory.newRetryEventDTOBuilder((RetryEvent)onSuccessEvent).numberOfAttempts(onSuccessEvent.getNumberOfRetryAttempts()).build();
            }
            case RETRY: {
                RetryOnRetryEvent onStateTransitionEvent = (RetryOnRetryEvent)event;
                return RetryEventDTOFactory.newRetryEventDTOBuilder((RetryEvent)onStateTransitionEvent).throwable(onStateTransitionEvent.getLastThrowable()).numberOfAttempts(onStateTransitionEvent.getNumberOfRetryAttempts()).build();
            }
            case IGNORED_ERROR: {
                RetryOnIgnoredErrorEvent onIgnoredErrorEvent = (RetryOnIgnoredErrorEvent)event;
                return RetryEventDTOFactory.newRetryEventDTOBuilder((RetryEvent)onIgnoredErrorEvent).throwable(onIgnoredErrorEvent.getLastThrowable()).build();
            }
        }
        throw new IllegalArgumentException("Invalid event");
    }

    private static RetryEventDTOBuilder newRetryEventDTOBuilder(RetryEvent event) {
        return new RetryEventDTOBuilder(event.getName(), event.getEventType(), event.getCreationTime().toString());
    }
}

