/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.autoconfigure;

import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.micrometer.BulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class})
@AutoConfigureAfter(value={BulkheadMetricsAutoConfiguration.class, MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.bulkhead.metrics.enabled"}, matchIfMissing=true)
public class BulkheadMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.bulkhead.metrics.use_legacy_binder"}, havingValue="true")
    public BulkheadMetrics registerLegacyBulkheadMetrics(BulkheadRegistry bulkheadRegistry) {
        return BulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.bulkhead.metrics.use_legacy_binder"}, havingValue="false", matchIfMissing=true)
    public TaggedBulkheadMetrics registerBulkheadMetrics(BulkheadRegistry bulkheadRegistry) {
        return TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry);
    }
}

