/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.rxjava3.AbstractObserver;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.concurrent.TimeUnit;

class ObserverRateLimiter<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final RateLimiter rateLimiter;

    ObserverRateLimiter(Observable<T> upstream, RateLimiter rateLimiter) {
        this.upstream = upstream;
        this.rateLimiter = rateLimiter;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        long waitDuration = this.rateLimiter.reservePermission();
        if (waitDuration >= 0L) {
            if (waitDuration > 0L) {
                Completable.timer((long)waitDuration, (TimeUnit)TimeUnit.NANOSECONDS).subscribe(() -> this.upstream.subscribe((Observer)new RateLimiterObserver(downstream)));
            } else {
                this.upstream.subscribe((Observer)new RateLimiterObserver(downstream));
            }
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter));
        }
    }

    class RateLimiterObserver
    extends AbstractObserver<T> {
        RateLimiterObserver(Observer<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
            ObserverRateLimiter.this.rateLimiter.onError(e);
        }

        @Override
        protected void hookOnNext(T value) {
            ObserverRateLimiter.this.rateLimiter.onResult(value);
        }

        @Override
        protected void hookOnComplete() {
        }

        @Override
        protected void hookOnCancel() {
        }
    }
}

