/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.rxjava3.AbstractSubscriber;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableCircuitBreaker<T>
extends Flowable<T> {
    private final CircuitBreaker circuitBreaker;
    private final Publisher<T> upstream;

    FlowableCircuitBreaker(Publisher<T> upstream, CircuitBreaker circuitBreaker) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.upstream = Objects.requireNonNull(upstream, "source is null");
    }

    protected void subscribeActual(Subscriber<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((Subscriber)new CircuitBreakerSubscriber(downstream));
        } else {
            downstream.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            downstream.onError((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)this.circuitBreaker));
        }
    }

    class CircuitBreakerSubscriber
    extends AbstractSubscriber<T> {
        private final long start;

        CircuitBreakerSubscriber(Subscriber<? super T> downstreamSubscriber) {
            super(downstreamSubscriber);
            this.start = FlowableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp();
        }

        @Override
        public void hookOnError(Throwable t) {
            FlowableCircuitBreaker.this.circuitBreaker.onError(FlowableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, FlowableCircuitBreaker.this.circuitBreaker.getTimestampUnit(), t);
        }

        @Override
        public void hookOnComplete() {
            FlowableCircuitBreaker.this.circuitBreaker.onSuccess(FlowableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, FlowableCircuitBreaker.this.circuitBreaker.getTimestampUnit());
        }

        @Override
        public void hookOnCancel() {
            if (this.eventWasEmitted.get()) {
                FlowableCircuitBreaker.this.circuitBreaker.onSuccess(FlowableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, FlowableCircuitBreaker.this.circuitBreaker.getTimestampUnit());
            } else {
                FlowableCircuitBreaker.this.circuitBreaker.releasePermission();
            }
        }
    }
}

