/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3;

import io.github.resilience4j.rxjava3.AbstractDisposable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractObserver<T>
extends AbstractDisposable
implements Observer<T> {
    protected final AtomicBoolean eventWasEmitted = new AtomicBoolean(false);
    private final Observer<? super T> downstreamObserver;

    public AbstractObserver(Observer<? super T> downstreamObserver) {
        this.downstreamObserver = Objects.requireNonNull(downstreamObserver);
    }

    @Override
    protected void hookOnSubscribe() {
        this.downstreamObserver.onSubscribe((Disposable)this);
    }

    public void onNext(T item) {
        this.whenNotDisposed(() -> {
            this.eventWasEmitted.set(true);
            this.downstreamObserver.onNext(item);
        });
    }

    public void onError(Throwable e) {
        this.whenNotCompleted(() -> {
            this.hookOnError(e);
            this.downstreamObserver.onError(e);
        });
    }

    protected abstract void hookOnError(Throwable var1);

    public void onComplete() {
        this.whenNotCompleted(() -> {
            this.hookOnComplete();
            this.downstreamObserver.onComplete();
        });
    }

    protected abstract void hookOnComplete();
}

