/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.rxjava3.AbstractCompletableObserver;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;

class CompletableCircuitBreaker
extends Completable {
    private final Completable upstream;
    private final CircuitBreaker circuitBreaker;

    CompletableCircuitBreaker(Completable upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(CompletableObserver downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((CompletableObserver)new CircuitBreakerCompletableObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)this.circuitBreaker));
        }
    }

    class CircuitBreakerCompletableObserver
    extends AbstractCompletableObserver {
        private final long start;

        CircuitBreakerCompletableObserver(CompletableObserver downstreamObserver) {
            super(downstreamObserver);
            this.start = CompletableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp();
        }

        @Override
        protected void hookOnComplete() {
            CompletableCircuitBreaker.this.circuitBreaker.onSuccess(CompletableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, CompletableCircuitBreaker.this.circuitBreaker.getTimestampUnit());
        }

        @Override
        protected void hookOnError(Throwable e) {
            CompletableCircuitBreaker.this.circuitBreaker.onError(CompletableCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, CompletableCircuitBreaker.this.circuitBreaker.getTimestampUnit(), e);
        }

        @Override
        protected void hookOnCancel() {
            CompletableCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

