/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.rxjava3.AbstractSingleObserver;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;

class SingleBulkhead<T>
extends Single<T> {
    private final Bulkhead bulkhead;
    private final Single<T> upstream;

    SingleBulkhead(Single<T> upstream, Bulkhead bulkhead) {
        this.upstream = upstream;
        this.bulkhead = bulkhead;
    }

    protected void subscribeActual(SingleObserver<? super T> downstream) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.upstream.subscribe((SingleObserver)new BulkheadSingleObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead));
        }
    }

    class BulkheadSingleObserver
    extends AbstractSingleObserver<T> {
        BulkheadSingleObserver(SingleObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
            SingleBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnSuccess() {
            SingleBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnCancel() {
            SingleBulkhead.this.bulkhead.releasePermission();
        }
    }
}

