/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractDisposable
implements Disposable {
    private final AtomicReference<Disposable> subscription = new AtomicReference();

    public void onSubscribe(Disposable disposable) {
        if (DisposableHelper.setOnce(this.subscription, (Disposable)disposable)) {
            this.hookOnSubscribe();
        }
    }

    protected abstract void hookOnSubscribe();

    public void dispose() {
        if (DisposableHelper.dispose(this.subscription)) {
            this.hookOnCancel();
        }
    }

    void whenNotDisposed(Runnable runnable) {
        if (!this.isDisposed()) {
            runnable.run();
        }
    }

    void whenNotCompleted(Runnable runnable) {
        if (DisposableHelper.dispose(this.subscription)) {
            runnable.run();
        }
    }

    protected abstract void hookOnCancel();

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.subscription.get());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

