/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.transformer;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.transformer.CompletableTimer;
import io.github.resilience4j.micrometer.transformer.FlowableTimer;
import io.github.resilience4j.micrometer.transformer.MaybeTimer;
import io.github.resilience4j.micrometer.transformer.ObservableTimer;
import io.github.resilience4j.micrometer.transformer.SingleTimer;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public class TimerTransformer<T>
implements FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer,
ObservableTransformer<T, T> {
    private final Timer timer;

    private TimerTransformer(Timer timer) {
        this.timer = Objects.requireNonNull(timer, "timer is null");
    }

    public static <T> TimerTransformer<T> of(Timer timer) {
        return new TimerTransformer<T>(timer);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableTimer<T>(upstream, this.timer);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new SingleTimer<T>(upstream, this.timer);
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableTimer(upstream, this.timer);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new MaybeTimer<T>(upstream, this.timer);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObservableTimer<T>(upstream, this.timer);
    }
}

