/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.transformer;

import io.github.resilience4j.timelimiter.TimeLimiter;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class TimeLimiterTransformer<T>
implements FlowableTransformer<T, T>,
ObservableTransformer<T, T>,
SingleTransformer<T, T>,
CompletableTransformer,
MaybeTransformer<T, T> {
    private final TimeLimiter timeLimiter;

    private TimeLimiterTransformer(TimeLimiter timeLimiter) {
        this.timeLimiter = timeLimiter;
    }

    public static <T> TimeLimiterTransformer<T> of(TimeLimiter timeLimiter) {
        return new TimeLimiterTransformer<T>(timeLimiter);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnNext(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnNext(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnSuccess(t -> this.timeLimiter.onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public CompletableSource apply(Completable upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return upstream.timeout(this.getTimeoutInMillis(), TimeUnit.MILLISECONDS).doOnSuccess(t -> this.timeLimiter.onSuccess()).doOnComplete(() -> ((TimeLimiter)this.timeLimiter).onSuccess()).doOnError(arg_0 -> ((TimeLimiter)this.timeLimiter).onError(arg_0));
    }

    private long getTimeoutInMillis() {
        return this.timeLimiter.getTimeLimiterConfig().getTimeoutDuration().toMillis();
    }
}

