/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.AbstractSingleObserver;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.TimeUnit;

class SingleRateLimiter<T>
extends Single<T> {
    private final RateLimiter rateLimiter;
    private final Single<T> upstream;

    SingleRateLimiter(Single<T> upstream, RateLimiter rateLimiter) {
        this.upstream = upstream;
        this.rateLimiter = rateLimiter;
    }

    protected void subscribeActual(SingleObserver<? super T> downstream) {
        long waitDuration = this.rateLimiter.reservePermission();
        if (waitDuration >= 0L) {
            if (waitDuration > 0L) {
                Completable.timer((long)waitDuration, (TimeUnit)TimeUnit.NANOSECONDS).subscribe(() -> this.upstream.subscribe((SingleObserver)new RateLimiterSingleObserver(downstream)));
            } else {
                this.upstream.subscribe((SingleObserver)new RateLimiterSingleObserver(downstream));
            }
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter));
        }
    }

    class RateLimiterSingleObserver
    extends AbstractSingleObserver<T> {
        RateLimiterSingleObserver(SingleObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
        }

        @Override
        protected void hookOnSuccess() {
        }

        @Override
        protected void hookOnCancel() {
        }
    }
}

