/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractSingleObserver;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class SingleCircuitBreaker<T>
extends Single<T> {
    private final CircuitBreaker circuitBreaker;
    private final Single<T> upstream;

    SingleCircuitBreaker(Single<T> upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(SingleObserver<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((SingleObserver)new CircuitBreakerSingleObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerSingleObserver
    extends AbstractSingleObserver<T> {
        private final StopWatch stopWatch;

        CircuitBreakerSingleObserver(SingleObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
            this.stopWatch = StopWatch.start();
        }

        @Override
        protected void hookOnError(Throwable e) {
            SingleCircuitBreaker.this.circuitBreaker.onError(this.stopWatch.stop().toNanos(), e);
        }

        @Override
        protected void hookOnSuccess() {
            SingleCircuitBreaker.this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }

        @Override
        protected void hookOnCancel() {
            SingleCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

