/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractMaybeObserver;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class MaybeCircuitBreaker<T>
extends Maybe<T> {
    private final Maybe<T> upstream;
    private final CircuitBreaker circuitBreaker;

    MaybeCircuitBreaker(Maybe<T> upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(MaybeObserver<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((MaybeObserver)new CircuitBreakerMaybeObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerMaybeObserver
    extends AbstractMaybeObserver<T> {
        private final StopWatch stopWatch;

        CircuitBreakerMaybeObserver(MaybeObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
            this.stopWatch = StopWatch.start();
        }

        @Override
        protected void hookOnComplete() {
            MaybeCircuitBreaker.this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }

        @Override
        protected void hookOnError(Throwable e) {
            MaybeCircuitBreaker.this.circuitBreaker.onError(this.stopWatch.stop().toNanos(), e);
        }

        @Override
        protected void hookOnSuccess() {
            MaybeCircuitBreaker.this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }

        @Override
        protected void hookOnCancel() {
            MaybeCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

