/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractCompletableObserver;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class CompletableCircuitBreaker
extends Completable {
    private final Completable upstream;
    private final CircuitBreaker circuitBreaker;

    CompletableCircuitBreaker(Completable upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(CompletableObserver downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((CompletableObserver)new CircuitBreakerCompletableObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerCompletableObserver
    extends AbstractCompletableObserver {
        private final StopWatch stopWatch;

        CircuitBreakerCompletableObserver(CompletableObserver downstreamObserver) {
            super(downstreamObserver);
            this.stopWatch = StopWatch.start();
        }

        @Override
        protected void hookOnComplete() {
            CompletableCircuitBreaker.this.circuitBreaker.onSuccess(this.stopWatch.stop().toNanos());
        }

        @Override
        protected void hookOnError(Throwable e) {
            CompletableCircuitBreaker.this.circuitBreaker.onError(this.stopWatch.stop().toNanos(), e);
        }

        @Override
        protected void hookOnCancel() {
            CompletableCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

