/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.operator.DisposableCircuitBreaker;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.Objects;

final class CircuitBreakerObserver<T>
extends DisposableCircuitBreaker<T>
implements Observer<T> {
    private final Observer<? super T> childObserver;

    CircuitBreakerObserver(CircuitBreaker circuitBreaker, Observer<? super T> childObserver) {
        super(circuitBreaker);
        this.childObserver = Objects.requireNonNull(childObserver);
    }

    public void onSubscribe(Disposable disposable) {
        this.onSubscribeWithPermit(disposable);
    }

    @Override
    protected void onSubscribeInner(Disposable disposable) {
        this.childObserver.onSubscribe(disposable);
    }

    public void onNext(T value) {
        this.onNextInner(value);
    }

    @Override
    protected void permittedOnNext(T value) {
        this.childObserver.onNext(value);
    }

    public void onComplete() {
        this.onCompleteInner();
    }

    @Override
    protected void permittedOnComplete() {
        this.childObserver.onComplete();
    }

    public void onError(Throwable e) {
        this.onErrorInner(e);
    }

    @Override
    protected void permittedOnError(Throwable e) {
        this.childObserver.onError(e);
    }
}

