/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class InMemoryRetryRegistry
implements RetryRegistry {
    private final RetryConfig defaultRetryConfig;
    private final ConcurrentMap<String, Retry> retries;

    public InMemoryRetryRegistry() {
        this.defaultRetryConfig = RetryConfig.ofDefaults();
        this.retries = new ConcurrentHashMap<String, Retry>();
    }

    public InMemoryRetryRegistry(RetryConfig defaultRetryConfig) {
        this.defaultRetryConfig = Objects.requireNonNull(defaultRetryConfig, "RetryConfig must not be null");
        this.retries = new ConcurrentHashMap<String, Retry>();
    }

    @Override
    public Seq<Retry> getAllRetries() {
        return Array.ofAll(this.retries.values());
    }

    @Override
    public Retry retry(String name) {
        return this.retries.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> Retry.of(name, this.defaultRetryConfig));
    }

    @Override
    public Retry retry(String name, RetryConfig customRetryConfig) {
        return this.retries.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> Retry.of(name, customRetryConfig));
    }

    @Override
    public Retry retry(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return this.retries.computeIfAbsent(Objects.requireNonNull(name, "Name must not be null"), k -> Retry.of(name, (RetryConfig)retryConfigSupplier.get()));
    }
}

