/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.IntervalFunction;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class RetryConfig {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_WAIT_DURATION = 500L;
    public static final IntervalFunction DEFAULT_INTERVAL_FUNCTION = numOfAttempts -> 500L;
    public static final Predicate<Throwable> DEFAULT_RECORD_FAILURE_PREDICATE = throwable -> true;
    private int maxAttempts = 3;
    private Predicate resultPredicate;
    private IntervalFunction intervalFunction = DEFAULT_INTERVAL_FUNCTION;
    private Predicate<Throwable> exceptionPredicate = DEFAULT_RECORD_FAILURE_PREDICATE;

    private RetryConfig() {
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Function<Integer, Long> getIntervalFunction() {
        return this.intervalFunction;
    }

    public Predicate<Throwable> getExceptionPredicate() {
        return this.exceptionPredicate;
    }

    public <T> Predicate<T> getResultPredicate() {
        return this.resultPredicate;
    }

    public static <T> Builder<T> custom() {
        return new Builder();
    }

    public static RetryConfig ofDefaults() {
        return new Builder().build();
    }

    public static class Builder<T> {
        private Predicate<Throwable> retryExceptionPredicate;
        private Predicate<Throwable> exceptionPredicate;
        private Predicate<T> resultPredicate;
        private IntervalFunction intervalFunction = IntervalFunction.ofDefaults();
        private Class<? extends Throwable>[] retryExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
        private int maxAttempts = 3;

        public Builder<T> maxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be greater than or equal to 1");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder<T> waitDuration(Duration waitDuration) {
            if (waitDuration.toMillis() < 10L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 10ms");
            }
            this.intervalFunction = x -> waitDuration.toMillis();
            return this;
        }

        public Builder<T> retryOnResult(Predicate<T> predicate) {
            this.resultPredicate = predicate;
            return this;
        }

        public Builder<T> intervalFunction(IntervalFunction f) {
            this.intervalFunction = f;
            return this;
        }

        public Builder<T> retryOnException(Predicate<Throwable> predicate) {
            this.retryExceptionPredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder<T> retryExceptions(Class<? extends Throwable> ... errorClasses) {
            this.retryExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder<T> ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public RetryConfig build() {
            this.buildExceptionPredicate();
            RetryConfig config = new RetryConfig();
            config.intervalFunction = this.intervalFunction;
            config.maxAttempts = this.maxAttempts;
            config.exceptionPredicate = this.exceptionPredicate;
            config.resultPredicate = this.resultPredicate;
            return config;
        }

        private void buildExceptionPredicate() {
            this.exceptionPredicate = this.getRetryPredicate().and(this.buildIgnoreExceptionsPredicate().orElse(DEFAULT_RECORD_FAILURE_PREDICATE));
        }

        private Predicate<Throwable> getRetryPredicate() {
            return this.buildRetryExceptionsPredicate().map(predicate -> this.retryExceptionPredicate != null ? predicate.or(this.retryExceptionPredicate) : predicate).orElseGet(() -> this.retryExceptionPredicate != null ? this.retryExceptionPredicate : DEFAULT_RECORD_FAILURE_PREDICATE);
        }

        private Optional<Predicate<Throwable>> buildRetryExceptionsPredicate() {
            return Arrays.stream(this.retryExceptions).distinct().map(Builder::makePredicate).reduce(Predicate::or);
        }

        private Optional<Predicate<Throwable>> buildIgnoreExceptionsPredicate() {
            return Arrays.stream(this.ignoreExceptions).distinct().map(Builder::makePredicate).reduce(Predicate::or).map(Predicate::negate);
        }

        static Predicate<Throwable> makePredicate(Class<? extends Throwable> exClass) {
            return e -> exClass.isAssignableFrom(e.getClass());
        }
    }
}

