/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.retry.AsyncRetry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AsyncRetryImpl
implements AsyncRetry {
    private final String name;
    private final int maxAttempts;
    private final Function<Integer, Long> intervalFunction;
    private final AsyncRetry.Metrics metrics;
    private final Predicate<Throwable> exceptionPredicate;
    private final RetryConfig config;
    private final RetryEventProcessor eventProcessor;
    private LongAdder succeededAfterRetryCounter;
    private LongAdder failedAfterRetryCounter;
    private LongAdder succeededWithoutRetryCounter;
    private LongAdder failedWithoutRetryCounter;

    public AsyncRetryImpl(String name, RetryConfig config) {
        this.config = config;
        this.name = name;
        this.maxAttempts = config.getMaxAttempts();
        this.intervalFunction = config.getIntervalFunction();
        this.exceptionPredicate = config.getExceptionPredicate();
        this.metrics = new AsyncRetryMetrics();
        this.succeededAfterRetryCounter = new LongAdder();
        this.failedAfterRetryCounter = new LongAdder();
        this.succeededWithoutRetryCounter = new LongAdder();
        this.failedWithoutRetryCounter = new LongAdder();
        this.eventProcessor = new RetryEventProcessor();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsyncRetry.Context context() {
        return new ContextImpl();
    }

    @Override
    public RetryConfig getRetryConfig() {
        return this.config;
    }

    private void publishRetryEvent(Supplier<RetryEvent> event) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(event.get());
        }
    }

    @Override
    public AsyncRetry.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public AsyncRetry.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private class RetryEventProcessor
    extends EventProcessor<RetryEvent>
    implements EventConsumer<RetryEvent>,
    AsyncRetry.EventPublisher {
        private RetryEventProcessor() {
        }

        public void consumeEvent(RetryEvent event) {
            super.processEvent((Object)event);
        }

        @Override
        public AsyncRetry.EventPublisher onRetry(EventConsumer<RetryOnRetryEvent> onRetryEventConsumer) {
            this.registerConsumer(RetryOnRetryEvent.class, onRetryEventConsumer);
            return this;
        }

        @Override
        public AsyncRetry.EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(RetryOnSuccessEvent.class, onSuccessEventConsumer);
            return this;
        }

        @Override
        public AsyncRetry.EventPublisher onError(EventConsumer<RetryOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(RetryOnErrorEvent.class, onErrorEventConsumer);
            return this;
        }

        @Override
        public AsyncRetry.EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(RetryOnIgnoredErrorEvent.class, onIgnoredErrorEventConsumer);
            return this;
        }
    }

    public final class AsyncRetryMetrics
    implements AsyncRetry.Metrics {
        private AsyncRetryMetrics() {
        }

        @Override
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt() {
            return AsyncRetryImpl.this.succeededWithoutRetryCounter.longValue();
        }

        @Override
        public long getNumberOfFailedCallsWithoutRetryAttempt() {
            return AsyncRetryImpl.this.failedWithoutRetryCounter.longValue();
        }

        @Override
        public long getNumberOfSuccessfulCallsWithRetryAttempt() {
            return AsyncRetryImpl.this.succeededAfterRetryCounter.longValue();
        }

        @Override
        public long getNumberOfFailedCallsWithRetryAttempt() {
            return AsyncRetryImpl.this.failedAfterRetryCounter.longValue();
        }
    }

    public final class ContextImpl
    implements AsyncRetry.Context {
        private final AtomicInteger numOfAttempts = new AtomicInteger(0);
        private final AtomicReference<Throwable> lastException = new AtomicReference();

        @Override
        public void onSuccess() {
            int currentNumOfAttempts = this.numOfAttempts.get();
            if (currentNumOfAttempts > 0) {
                AsyncRetryImpl.this.publishRetryEvent(() -> new RetryOnSuccessEvent(AsyncRetryImpl.this.name, currentNumOfAttempts, this.lastException.get()));
            }
        }

        @Override
        public long onError(Throwable throwable) {
            if (!AsyncRetryImpl.this.exceptionPredicate.test(throwable)) {
                AsyncRetryImpl.this.failedWithoutRetryCounter.increment();
                AsyncRetryImpl.this.publishRetryEvent(() -> new RetryOnIgnoredErrorEvent(AsyncRetryImpl.this.getName(), throwable));
                return -1L;
            }
            this.lastException.set(throwable);
            int attempt = this.numOfAttempts.incrementAndGet();
            if (attempt >= AsyncRetryImpl.this.maxAttempts) {
                AsyncRetryImpl.this.failedAfterRetryCounter.increment();
                AsyncRetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(AsyncRetryImpl.this.name, attempt, throwable));
                return -1L;
            }
            long interval = (Long)AsyncRetryImpl.this.intervalFunction.apply(attempt);
            AsyncRetryImpl.this.publishRetryEvent(() -> new RetryOnRetryEvent(AsyncRetryImpl.this.getName(), attempt, throwable, interval));
            return interval;
        }
    }
}

