/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.vavr.CheckedConsumer;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RetryImpl
implements Retry {
    private final Retry.Metrics metrics;
    private final RetryEventProcessor eventProcessor;
    private String name;
    private RetryConfig config;
    private int maxAttempts;
    private Function<Integer, Long> intervalFunction;
    private Predicate<Throwable> exceptionPredicate;
    private LongAdder succeededAfterRetryCounter;
    private LongAdder failedAfterRetryCounter;
    private LongAdder succeededWithoutRetryCounter;
    private LongAdder failedWithoutRetryCounter;
    static CheckedConsumer<Long> sleepFunction = Thread::sleep;

    public RetryImpl(String name, RetryConfig config) {
        this.name = name;
        this.config = config;
        this.maxAttempts = config.getMaxAttempts();
        this.intervalFunction = config.getIntervalFunction();
        this.exceptionPredicate = config.getExceptionPredicate();
        this.metrics = new RetryMetrics();
        this.eventProcessor = new RetryEventProcessor();
        this.succeededAfterRetryCounter = new LongAdder();
        this.failedAfterRetryCounter = new LongAdder();
        this.succeededWithoutRetryCounter = new LongAdder();
        this.failedWithoutRetryCounter = new LongAdder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Retry.Context context() {
        return new ContextImpl();
    }

    @Override
    public RetryConfig getRetryConfig() {
        return this.config;
    }

    private void publishRetryEvent(Supplier<RetryEvent> event) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(event.get());
        }
    }

    @Override
    public Retry.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public Retry.Metrics getMetrics() {
        return this.metrics;
    }

    private class RetryEventProcessor
    extends EventProcessor<RetryEvent>
    implements EventConsumer<RetryEvent>,
    Retry.EventPublisher {
        private RetryEventProcessor() {
        }

        public void consumeEvent(RetryEvent event) {
            super.processEvent((Object)event);
        }

        @Override
        public Retry.EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(RetryOnSuccessEvent.class, onSuccessEventConsumer);
            return this;
        }

        @Override
        public Retry.EventPublisher onError(EventConsumer<RetryOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(RetryOnErrorEvent.class, onErrorEventConsumer);
            return this;
        }

        @Override
        public Retry.EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(RetryOnIgnoredErrorEvent.class, onIgnoredErrorEventConsumer);
            return this;
        }
    }

    public final class RetryMetrics
    implements Retry.Metrics {
        private RetryMetrics() {
        }

        @Override
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt() {
            return RetryImpl.this.succeededWithoutRetryCounter.longValue();
        }

        @Override
        public long getNumberOfFailedCallsWithoutRetryAttempt() {
            return RetryImpl.this.failedWithoutRetryCounter.longValue();
        }

        @Override
        public long getNumberOfSuccessfulCallsWithRetryAttempt() {
            return RetryImpl.this.succeededAfterRetryCounter.longValue();
        }

        @Override
        public long getNumberOfFailedCallsWithRetryAttempt() {
            return RetryImpl.this.failedAfterRetryCounter.longValue();
        }
    }

    public final class ContextImpl
    implements Retry.Context {
        private final AtomicInteger numOfAttempts = new AtomicInteger(0);
        private final AtomicReference<Exception> lastException = new AtomicReference();
        private final AtomicReference<RuntimeException> lastRuntimeException = new AtomicReference();

        private ContextImpl() {
        }

        @Override
        public void onSuccess() {
            int currentNumOfAttempts = this.numOfAttempts.get();
            if (currentNumOfAttempts > 0) {
                RetryImpl.this.succeededAfterRetryCounter.increment();
                Throwable throwable = (Throwable)Option.of((Object)this.lastException.get()).getOrElse((Object)this.lastRuntimeException.get());
                RetryImpl.this.publishRetryEvent(() -> new RetryOnSuccessEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable));
            } else {
                RetryImpl.this.succeededWithoutRetryCounter.increment();
            }
        }

        @Override
        public void onError(Exception exception) throws Throwable {
            if (!RetryImpl.this.exceptionPredicate.test(exception)) {
                RetryImpl.this.failedWithoutRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnIgnoredErrorEvent(RetryImpl.this.getName(), exception));
                throw exception;
            }
            this.lastException.set(exception);
            this.throwOrSleepAfterException();
        }

        @Override
        public void onRuntimeError(RuntimeException runtimeException) {
            if (!RetryImpl.this.exceptionPredicate.test(runtimeException)) {
                RetryImpl.this.failedWithoutRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnIgnoredErrorEvent(RetryImpl.this.getName(), runtimeException));
                throw runtimeException;
            }
            this.lastRuntimeException.set(runtimeException);
            this.throwOrSleepAfterRuntimeException();
        }

        private void throwOrSleepAfterException() throws Exception {
            int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
            if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                Exception throwable = this.lastException.get();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable));
                throw throwable;
            }
            this.waitIntervalAfterFailure();
        }

        private void throwOrSleepAfterRuntimeException() {
            int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
            if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                RuntimeException throwable = this.lastRuntimeException.get();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable));
                throw throwable;
            }
            this.waitIntervalAfterFailure();
        }

        private void waitIntervalAfterFailure() {
            long interval = (Long)RetryImpl.this.intervalFunction.apply(this.numOfAttempts.get());
            Try.run(() -> sleepFunction.accept((Object)interval)).getOrElseThrow(ex -> this.lastRuntimeException.get());
        }
    }
}

